// @format
import React from "react";
import Icon from "react-icons-kit";
import { github } from "react-icons-kit/fa/github";
import { amazon } from "react-icons-kit/icomoon/amazon";
import { slack } from "react-icons-kit/fa/slack";
import { envelope } from "react-icons-kit/fa/envelope";
import { ticket } from "react-icons-kit/fa/ticket";
import Clock from "react-live-clock";
import PropTypes from "prop-types";
import { LinkContainer } from "react-router-bootstrap";
import "./PageLayout.scss";
import {
  Grid,
  Row,
  Col,
  Navbar,
  Nav,
  MenuItem,
  NavItem,
  Glyphicon, Button,
} from "react-bootstrap";
import {
  toMetric,
  toService,
  toComponent,
  toAccount,
  toOrg,
  toTeam,
  toBase,
} from "lib/formatters";
import "react-select/dist/react-select.css";
import index from "../../lib/authUtils/index";
import ReadOnlyModeBanner from "../../components/ReadOnlyModeBanner";
import BannerMessage from "../../components/Banner";
import { READ_ONLY_MODE } from "../../constants";

const topNavPurple = '#4b367c';
const topNavGray = 'dimgray';

class NavLink extends React.Component {
  render() {
    return (
      <LinkContainer to={this.props.to}>
        <MenuItem {...this.props} />
      </LinkContainer>
    );
  }
}
class PageLayout extends React.Component {
  render() {
    let { children } = this.props;
    let selectedTab = 1;
    if (document.location.href.indexOf("/logReports/") !== -1) {
      selectedTab = 2;
    } else if (document.location.href.indexOf("/serviceOwner") !== -1) {
      selectedTab = 3;
    } else if (document.location.href.indexOf("/services/new") !== -1) {
      selectedTab = 4;
    }
    return (
      <div>
        <Navbar staticTop default>
          <Nav bsStyle="tabs" activeKey="2">
            {selectedTab === 1 && <NavItem style={{ backgroundColor: topNavGray, borderTopLeftRadius: '10px', borderTopRightRadius: '10px' }} eventKey={1} href="/">
              Service Catalog
            </NavItem>}
            {selectedTab !== 1 && <NavItem style={{ backgroundColor: topNavPurple }} eventKey={1} href="/">
              Service Catalog
            </NavItem>}
            {selectedTab === 2 && <NavItem style={{ backgroundColor: topNavGray, borderTopLeftRadius: '10px', borderTopRightRadius: '10px' }} eventKey={2} href="/logReports/">
              Log Reports
            </NavItem>}
            {selectedTab !== 2 && <NavItem style={{ backgroundColor: topNavPurple }} eventKey={2} href="/logReports/">
              Log Reports
            </NavItem>}
            {selectedTab === 3 && <NavItem style={{ backgroundColor: topNavGray, borderTopLeftRadius: '10px', borderTopRightRadius: '10px' }} eventKey={3} href="/serviceOwner/">
              My Services
            </NavItem>}
            {selectedTab !== 3 && <NavItem style={{ backgroundColor: topNavPurple }} eventKey={3} href="/serviceOwner/">
              My Services
            </NavItem>}
            {selectedTab === 4 && <NavItem style={{ backgroundColor: topNavGray, borderTopLeftRadius: '10px', borderTopRightRadius: '10px' }} eventKey={4} href="/services/new">
              Create Service
            </NavItem>}
            {selectedTab !== 4 && <NavItem style={{ backgroundColor: topNavPurple }} eventKey={4} href="/services/new">
              Create Service
            </NavItem>}
          </Nav>
          <Nav pullRight>
            <NavItem>
              <Glyphicon glyph="time"/> UTC:{" "}
              <Clock format={"HH:mm:ss"} ticking timezone={"UTC"}/>&nbsp;
            </NavItem>
          </Nav>
        </Navbar>
        <Grid>
          <Row>
            {READ_ONLY_MODE ? <ReadOnlyModeBanner /> : <BannerMessage />}
          </Row>
          <Row>{children}</Row>
          <hr/>
          <div className="footer-container">
            <Row>
              <Col md={4} sm={4}>
                <b>Questions?</b>
                <br/>
                <Icon icon={slack}/>{" "}
                <a
                  href="https://twitch.slack.com/app_redirect?channel=C330HF7DH"
                  target="_blank"
                >
                  service-catalog
                </a>
                <br/>
                <Icon icon={envelope}/>{" "}
                <a href="mailto:builder-products@twitch.tv" target="_blank">
                  builder-products@twitch.tv
                </a>
                <br/>
                <Icon icon={ticket}/>{" "}
                <a
                  href="https://jira.twitch.com/secure/CreateIssue.jspa?pid=26341&issuetype=1"
                  target="_blank"
                >
                  Builder Products JIRA
                </a>
                <br/>
              </Col>
              <Col md={4} sm={4}>
                <b>Links</b>
                <br/>
                <a
                  href="https://wiki.twitch.com/pages/viewpage.action?pageId=176657084"
                  target="_blank"
                >
                  Getting Started
                </a>
                <br/>
                <a
                  href="https://wiki.twitch.com/display/PS/Twitch+Internal+Dashboard%3A+Release+Notes"
                  target="_blank"
                >
                  Release Notes
                </a>
                <br/>
              </Col>
              <Col md={4} sm={4}>
                <b>Code</b>
                <br/>
                <Icon icon={github}/>{" "}
                <a
                  href="https://git-aws.internal.justin.tv/availability/tinker"
                  target="_blank"
                >
                  tinker (React client)
                </a>
                <br/>
                <Icon icon={amazon}/>{" "}
                <a
                  href="https://code.amazon.com/packages/TwitchServiceCatalogLambda/trees/mainline"
                  target="_blank"
                >
                  goracle (fultonized graphql API)
                </a>
                <br/>
              </Col>
            </Row>
          </div>
        </Grid>
      </div>
    );
  }
};

PageLayout.propTypes = {
  children: PropTypes.node,
};

export default PageLayout;
