// Schema string generated using `graphql get-schema` (graphql-cli)
export const schemaString = `
# source: http://localhost:8000/api/v2/query.guardian
# timestamp: Wed Jun 06 2018 17:23:19 GMT-0700 (PDT)

schema {
  query: QueryQL
  mutation: MutationQL
}

type Account {
  id: ID!
  alias: String!
  description: String!
  aws_account_id: String!
  org_id: ID
  org: Org
  components: [Component]!
  component_ids: [ID!]!
  attributes: [Attribute]!
}

input AccountInput {
  alias: String
  description: String
  aws_account_id: String
  org_id: ID
}

type Attribute {
  id: ID!

  """
  the type of the object the attribute is attached to
  possible values: service, component metric
  """
  object_type: String!

  """the ID of the object the attribute is attached to"""
  object_id: ID!
  name: String!
  value: String!
}

input AttributeInput {
  id: ID

  """
  the type of the object the attribute is attached to
  possible values: service, component metric
  """
  object_type: String!

  """the ID of the object the attribute is attached to"""
  object_id: ID!
  name: String!
  value: String
  deleted: Boolean
}

"""Represents a service component"""
type Component {
  id: ID!
  name: String!
  label: String!
  description: String!

  """
  rollup flag, specifying if the component should be included in availability rollup calculations
  """
  rollup: Boolean!
  claimed: Boolean!
  type: String!

  """the ID of the serivice the component is assigned to"""
  service_id: ID

  """the service item the component is assigned to"""
  service: Service
  account_id: ID
  account: Account
  metrics: [Metric]!
  metric_ids: [ID!]!
  attributes: [Attribute]!
  logs(offset: Int, limit: Int): [LogRecord]!
}

input ComponentInput {
  id: ID
  name: String

  """must be unique"""
  label: String
  description: String
  rollup: Boolean
  claimed: Boolean
  type: String
  service_id: ID
  account_id: ID
  metric_ids: [ID!]
  metrics: [MetricInput!]
  attributes: [AttributeInput]
}

type Feature {
  id: ID!
  label: String!
  name: String!
  description: String!
  metrics: [Metric]!
  metric_ids: [ID!]!
  children: [Feature]!
  children_ids: [ID!]!
  parent: Feature
  parent_id: ID
  attributes: [Attribute]!
}

"""
LogRecords describe a change to an item such as a service, component or metric
LogRecord entries are created automatically by the catalog service when changes are made
and can be fetched either the top level logs query or the logs subqueries attached to various types
"""
type LogRecord {
  id: ID!

  """the recorded action, possible values: create, update, delete"""
  action: String!

  """
  the type of the item addected by the action
  possible values are: service component metric query team account org attribute featureservice_dependency
  """
  item_type: String!

  """the label of the affected item"""
  item_label: String!

  """the id of the affected item"""
  item_id: ID!

  """json representation of the item before the change"""
  before: String!

  """json representation of the item after the change"""
  after: String!

  """
  the authenticated user who submitted the change. empty for anonymous actions
  """
  author: String!

  """the timestamp of the action"""
  created: String!
}

type Metric {
  id: ID!
  label: String!
  name: String!
  description: String!
  features: [Feature]!
  feature_ids: [ID!]!
  feature_rollup: Boolean!
  component_rollup: Boolean!
  autogenerated: Boolean!
  queries: [Query]!
  query_ids: [ID!]!
  threshold: Float!
  component: Component
  component_id: ID
  latency_query: String!
  latency_objective: Float!
  calculation_type: String!
  attributes: [Attribute]!
  logs(offset: Int, limit: Int): [LogRecord]!
}

input MetricInput {
  id: ID

  """must be unique"""
  label: String
  name: String
  description: String
  component_rollup: Boolean
  autogenerated: Boolean
  threshold: Float
  component_id: ID
  latency_query: String
  latency_objective: Float
  calculation_type: String
  queries: [QueryInput!]
  attributes: [AttributeInput]
}

type MutationQL {
  createComponent(component: ComponentInput!): Component
  updateComponent(id: ID!, component: ComponentInput!): Component
  deleteComponent(id: ID!): Component
  createService(service: ServiceInput!): Service
  updateService(id: ID!, service: ServiceInput!): Service
  deleteService(id: ID!): Service
  createAttribute(attribute: AttributeInput!): Attribute
  updateAttribute(id: ID!, attribute: AttributeInput!): Attribute
  deleteAttribute(id: ID!): Attribute
  createMetric(metric: MetricInput!): Metric
  updateMetric(id: ID!, metric: MetricInput!): Metric
  deleteMetric(id: ID!): Metric
  createAccount(account: AccountInput!): Account
  updateAccount(id: ID!, account: AccountInput!): Account
  deleteAccount(id: ID!): Account
  createOrg(org: OrgInput!): Org
  updateOrg(id: ID!, org: OrgInput!): Org
  deleteOrg(id: ID!): Org
  createTeam(team: TeamInput!): Team
  updateTeam(id: ID!, team: TeamInput!): Team
  deleteTeam(id: ID!): Team
  createQuery(query: QueryInput!): Query
  updateQuery(id: ID!, query: QueryInput!): Query
  deleteQuery(id: ID!): Query
  createServiceAudit(service_audit: ServiceAuditInput!): ServiceAudit
  createServiceDependency(service_dependency: ServiceDependencyInput!): ServiceDependency
  deleteServiceDependency(id: ID!): ServiceDependency
  createEndpoint(endpoint: EndpointInput!): Endpoint
  updateEndpoint(id: ID!, endpoint: EndpointInput!): Endpoint
  deleteEndpoint(id: ID!): Endpoint
}

type Org {
  id: ID!
  name: String!
  label: String!
  description: String!
  parent: Org
  parent_id: Int
  accounts: [Account]!
  account_ids: [ID!]!
  teams: [Team]!
  team_ids: [ID!]!
  attributes: [Attribute]!
}

input OrgInput {
  name: String

  """must be unique"""
  label: String
  description: String
  parent_id: ID
}

type Query {
  id: ID!
  query_type: String!
  aggregate_type: String!
  query: String!
  metric: Metric
  metric_id: ID
  attributes: [Attribute]!
}

input QueryInput {
  id: ID
  query_type: String
  aggregate_type: String
  query: String
  metric_id: ID
}

type QueryQL {
  """get the component with the given ID"""
  component(id: ID!): Component

  """get all components matching the specified filters"""
  components(label: String, service_id: ID, attribute_name: String, attribute_value: String): [Component]!

  """get the service  with the given ID"""
  service(id: ID!): Service

  """get all services matching the specified filters"""
  services(attribute_name: String, attribute_value: String): [Service]!

	"""get all services belonging to a given primary owner"""
	servicesForOwner(uid: String): [Service]!

  """get the team with the given ID"""
  team(id: ID!): Team

  """get all services matching the specified filters"""
  teams(attribute_name: String, attribute_value: String): [Team]!

  """get the account with the given ID"""
  account(id: ID!): Account

  """get all accounts matching the specified filters"""
  accounts(alias: String, attribute_name: String, attribute_value: String): [Account]!

  """get the organization with the given ID"""
  org(id: ID!): Org

  """get all organizations matching the specified filters"""
  orgs(label: String): [Org]!

  """get the query with the given ID"""
  query(id: ID!): Query

  """get all queries matching the specified filters"""
  queries(attribute_name: String, attribute_value: String): [Query]!

  """get the metric with the given ID"""
  metric(id: ID!): Metric

  """get all metrics matching the specified filters"""
  metrics(component_id: ID, calculation_type: String, attribute_name: String, attribute_value: String): [Metric]!

  """get the feature with the given ID"""
  feature(id: ID!): Feature

  """get all features matching the specified filters"""
  features(attribute_name: String, attribute_value: String): [Feature]!

  """
  get the attributes matching the specified filters
  object_type possible values: service, component metric
  """
  attributes(object_type: String, object_id: ID, name: String, value: String, unique: Boolean): [Attribute]!

  """
  get the service audits for the specified service
  latest: only fetch the latest audit
  """
  serviceAudits(service_id: ID, latest: Boolean): [ServiceAudit]!

  """get the service dependencies matching the specified parameters"""
  serviceDependencies(root_service_id: ID, downstream_service_id: ID, attribute_name: String, attribute_value: String): [ServiceDependency]!

  """get the change log entries matching the specified parameters"""
  logs(item_type: String, item_id: ID, action: String, author: String, offset: Int, limit: Int): [LogRecord]!

  """
  get the LDAP information of the user with the specified employee number
  """
  user(employee_number: ID!): User

  """get the information of all users found in LDAP"""
  users: [User]!
  slack: Slack!

  """get all endpoints for the specified service"""
  serviceEndpoints(service_id: ID!): [Endpoint]!

  """get all PDMS user data types"""
  defaultUserDataTypes: [UserDataType]!
}

type Service {
  id: ID!
  name: String!
  state: String!
  stores_user_data: Boolean
  access_requests: Boolean
  access_exception: String
  access_exception_validated_by: String
  deletion_requests: Boolean
  deletion_exception: String
  deletion_exception_validated_by: String
  user_data_types: [UserDataType]!
  description: String!
  team_id: ID
  team: Team
  primary_owner_id: ID
  primary_owner: User
  components: [Component]!
  component_ids: [ID!]!
  availability_objective: Float!
  environment: String!
  known: Boolean!
  type: String!
  created: String!
  updated: String!
  attributes: [Attribute]!
  service_audits: [ServiceAudit]!
  service_downstreams: [ServiceDependency]!
  service_upstreams: [ServiceDependency]!
  latest_service_audits: [ServiceAudit]!
  logs(offset: Int, limit: Int): [LogRecord]!
  pagerduty: String!
  slack: String!
  slack_channel: SlackChannel
  slack_channel_id: ID
  endpoints: [Endpoint]!
}

type ServiceAudit {
  id: ID!

  """the ID of the service the audit is attached to"""
  service_id: ID!

  """
  the type of the audit
  possible values: availability, component, latency, owner, dependencies
  """
  audit_type: String!

  """
  the authenticated user who submitted the audit. empty for anonymous actions
  """
  auditor: String!

  """the type of audit action. possible values: validated, invalidated"""
  action: String!
  audit_time: String!

  """the value of primary-owner at the time of audit action."""
  audit_value: String
}

input ServiceAuditInput {
  service_id: ID!
  audit_type: String!
  action: String!
  audit_value: String!
}

type ServiceDependency {
  id: ID!
  root_service_id: ID!
  root_service: Service
  downstream_service_id: ID!
  downstream_service: Service
  attributes: [Attribute]!
}

input ServiceDependencyInput {
  id: ID
  root_service_id: ID
  root_service: ServiceInput
  downstream_service_id: ID
  downstream_service: ServiceInput
  attributes: [AttributeInput]
}

input ServiceInput {
  id: ID
  name: String
  state: String
  stores_user_data: Boolean
  access_requests: Boolean
  access_exception: String
  access_exception_validated_by: String
  deletion_requests: Boolean
  deletion_exception: String
  deletion_exception_validated_by: String
  user_data_types: [UserDataTypeInput]
  description: String
  team_id: ID
  primary_owner_id: ID
  availability_objective: Float
  environment: String
  known: Boolean
  type: String
  component_ids: [ID!]
  components: [ComponentInput!]
  attributes: [AttributeInput]
  service_upstreams: [ServiceDependencyInput!]
  service_downstreams: [ServiceDependencyInput!]
  pagerduty: String
  slack: String
  slack_channel_id: ID
  endpoints: [EndpointInput!]
}

type Slack {
  users: [SlackUser]!
  channels: [SlackChannel]!
}

type SlackChannel {
  id: ID!
  name: String!
  topic: String!
  purpose: String!
}

type SlackUser {
  id: ID!
  name: String!
  realname: String!
}

type Team {
  id: ID!
  name: String!
  label: String!
  email: String!
  slack: String!
  slack_channel: SlackChannel
  slack_channel_id: ID
  description: String!
  org: Org
  org_id: ID
  services: [Service]!
  service_ids: [ID!]!
  attributes: [Attribute]!
  pagerduty: String!
}

input TeamInput {
  name: String

  """must be unique"""
  label: String
  slack: String
  slack_channel_id: ID
  email: String
  description: String
  org_id: ID
  attributes: [AttributeInput]
  pagerduty: String
}

type User {
  employee_number: ID
  inactive: Boolean
  cn: String
  uid: String
  amazon_uid: String
  department: String
  manager: String
  building_name: String
  preferred_name: String
  slack: SlackUser
  status: String!
  error: String
}

type Endpoint {
    id: ID!
    service_id: ID!
    region: String!
    stage: String!
    vpc_endpoint_service_id: String!
    hostname: String!
    port: Int!
    ssl_enabled: Boolean!
}
input EndpointInput {
    id: ID
    service_id: ID
    region: String!
    stage: String!
    vpc_endpoint_service_id: String
    hostname: String!
    port: Int!
    ssl_enabled: Boolean!
}
type UserDataType {
  id: ID!
  parent_type: UserDataType
  label: String!
  description: String!
}

input UserDataTypeInput {
  id: ID
  parent_type: UserDataTypeInput
  label: String
  description: String
}
`;
