// @format
// An auth middleware
// This will intercept actions and make sure that the
// guardian token issued has not expired. If it has,
// this middleware will force the user to re-auth before continuing

import Cookies from "js-cookie";

const authMiddleware = store => next => action => {
  // Essentailly, if the scAuthToken cookie
  // isn't set, then reload the page. This will
  // force the browser to fetch the bundle, which
  // will prompt for auth before doing so.
  let scAuthToken = Cookies.get("scAuthUser");
  let scAuthTokenFromSession = window.localStorage.getItem("service-catalog:session");
  if (scAuthToken === undefined && scAuthTokenFromSession === undefined) {
    console.log("No scAuthToken! Reloading the page!");
    window.location.reload();
  }
  let result = next(action);
  // nothing to do afterwards
  return result;
};

export function getUser() {
  let scAuthUser = Cookies.get("scAuthUser");
  if (scAuthUser === undefined) {
    console.log("No scAuthUser found!");
    return "";
  }
  return scAuthUser;
}

export default authMiddleware;
