import moment from "moment";
import "moment-timezone";

// Set the timezone to UTC
moment.tz.setDefault("UTC");

export function utcNow() {
  return moment().tz("UTC");
}

export function utcDay(date) {
  var d;
  if (date === undefined) {
    d = utcNow();
  } else {
    d = moment(date).tz("UTC");
  }
  return d.startOf("day");
}

export function utcWeek(date) {
  var d;
  if (date === undefined) {
    d = utcNow();
  } else {
    d = moment(date).tz("UTC");
  }
  if (d.day() == 0) {
    // Sunday, use last monday
    return d.day(-7 + 1).startOf("day");
  }
  return d.day(1).startOf("day");
}

export function utcParser(dateStr) {
  return moment(dateStr).tz("UTC");
}

export function dateStr(d) {
  return moment(d)
    .tz("UTC")
    .format("YYYY-MM-DD");
}
