const NODE_ENV = process.env.NODE_ENV || "local";
const GORACLE_DEV_URL = process.env.GORACLE_DEV_URL;
export const __LOCAL__ = NODE_ENV === "local";
export const __DEV__ = NODE_ENV === "beta";
export const __TEST__ = NODE_ENV === "test";
export const __PROD__ = NODE_ENV === "prod";

export function GetEnvironment() {
  if (__LOCAL__ || __TEST__) {
    return "local";
  }
  return window.env.ENVIRONMENT;
}

export function IsProduction() {
  return GetEnvironment() === "prod"
}

export function IsDevelopment() {
  return GetEnvironment() === "beta"
}

export function IsLocal() {
  return GetEnvironment() === "local"
}

export function GetAPIBaseURL() {
  if (__LOCAL__ || __TEST__) {
    return GORACLE_DEV_URL + "/api/v2/query.guardian";
  }
  return window.env.API_BASE;
}

export function GetMessagingBaseURL() {
  if (__LOCAL__ || __TEST__) {
    return "http://localhost:8000/messaging";
  }

  return window.env.MESSAGING_BASE;
}

export function GetHMSBaseURL() {
  if (__LOCAL__ || __TEST__) {
    return "http://hms-esk-development.internal.justin.tv/v1";
  }
  return window.env.HMS_BASE;
}

export function GetGuardianClientID() {
  if (IsDevelopment()) {
    return 'b4656ae0-5af0-4f3f-87fb-897e68a21a60';
  }
  if (IsLocal()) {
    return '76488da8-3a46-49fc-aee7-a3c6dc9e6a43';
  }
  // default Prod
  return '73846cb0-d273-4601-9266-a37a68a39227';
}

export function GetGuardianCompletionUrl() {
  if (IsDevelopment()) {
    return 'https://servicecatalog-beta.internal.justin.tv/oauth2/callback';
  }
  if (IsLocal()) {
    return 'http://servicecatalog-local.internal.justin.tv:3000/oauth2/callback';
  }
  // default Prod
  return 'https://servicecatalog.internal.justin.tv/oauth2/callback';
}
