import React from "react";
import ReactDOM from "react-dom";
import createStore from "./store/createStore";
import "./styles/main.scss";
import { __DEV__, __LOCAL__, __PROD__, __TEST__ } from "./lib/env";

// Store Initialization
// ------------------------------------
export const store = createStore(window.__INITIAL_STATE__);

// Render Setup
// ------------------------------------
const MOUNT_NODE = document.getElementById("root");

let render = () => {
  const App = require("./components/App").default;
  // const routes = require("./routes/index").default(store);
  ReactDOM.render(
    <App store={store.store} history={store.history} />,
    MOUNT_NODE
  );
};

// Development Tools
// ------------------------------------
if (__DEV__ || __LOCAL__) {
  if (module.hot) {
    const renderApp = render;
    const renderError = error => {
      const RedBox = require("redbox-react").default;

      ReactDOM.render(<RedBox error={error} />, MOUNT_NODE);
    };

    render = () => {
      try {
        renderApp();
      } catch (e) {
        console.error(e);
        renderError(e);
      }
    };

    // Setup hot module replacement
    module.hot.accept(["./components/App", "./routes/index"], () =>
      setImmediate(() => {
        ReactDOM.unmountComponentAtNode(MOUNT_NODE);
        render();
      })
    );
  }
}

// Let's Go!
// ------------------------------------
if (!__TEST__) render();
