import React from "react";
import index from "../../lib/authUtils/index";
import Cookies from "js-cookie";
import { GetGuardianClientID, GetGuardianCompletionUrl } from "../../lib/env";

var guardianClientInitialized = false;

class LoginComponent extends React.Component {

  render() {

    if (!guardianClientInitialized) {
      var guardianClient = index.guardianClient({
        guardianUrl: '/proxy/guardian/api',
        guardianClientID: GetGuardianClientID(),
        guardianRedirectUrl: 'https://guardian.internal.justin.tv',
        completionUrl: GetGuardianCompletionUrl(),
      });
      guardianClientInitialized = true;
    }

    // if the path is /oauth2/callback, handle the authorization
    // completion to generate an access token in local storage
    if (window.location.pathname.includes('/oauth2/callback')) {
      guardianClient.handleCompletion()
      this.props.history.push('/');
    } else {
      try {
        let token = window.localStorage.getItem("service-catalog:session");
        if (!token && guardianClient) {
          guardianClient.redirectToAuth();
        }
      } catch (err) {
        switch (err) {
          case (index.errSessionInvalidated):
          case (index.errUserNotAuthenticated):
            if (guardianClient) {
              guardianClient.redirectToAuth();
            }
            break;
          default:
            throw err;
        }
      }
    }

    let scAuthToken = Cookies.get('scAuthToken');
    if (!scAuthToken && guardianClient) {
      guardianClient.redirectToAuth();
    }

    return <div>
      {/*returns an empty div; this component ensures user is authenticated*/}
    </div>
  }

}

export default LoginComponent;
