import React from "react";
import PropTypes from "prop-types";
import { Button, ButtonToolbar, Col, Row, Table } from "react-bootstrap";
import { CSVLink } from "react-csv";
import { jsonPretty } from "../../../common/LogRecord/components/LogRecord";
import { isFilterAutoEnabled } from "../LogReportsPage";
import { WrapperTooltip } from "../../../components/WrapperTooltip";

const tableHeader = "Log Reports";

const CSVExport = ({ csvData }) => {
  // preserve formatting for "before" and "after" json-prettified fields
  csvData.forEach(function(log) {
    let regex = /"/gi;
    log.before = log.before.replace(regex, '""');
    log.after = log.after.replace(regex, '""');
  });
  return (
    <CSVLink data={csvData} filename={"logReports.csv"} target={"_blank"}>
      <ButtonToolbar>
        <Button bsStyle="primary">Download CSV</Button>
      </ButtonToolbar>
    </CSVLink>
  );
};

var preStyle = {
  width: "400px",
  overflow: "auto",
  fontSize: "10px",
};

export var logReportsColumns = [
  {
    title: "LogID",
    key: "id",
  },
  {
    title: "Change Time",
    key: "created",
  },
  {
    title: "Author",
    key: "author",
  },
  {
    title: "Action",
    key: "action",
  },
  {
    title: "Type",
    key: "item_type",
  },
  {
    title: "Item Label",
    key: "item_label",
  },
  {
    title: "Item ID",
    key: "item_id",
  },
  {
    title: "Before",
    key: "before",
  },
  {
    title: "After",
    key: "after",
  },
];

class LogReportsTable extends React.Component {

  render()
  {
    let { logs } = this.props;
    return <div>
      <Row>
        <Col md={12}>
          <Col md={2} mdOffset={0} >
            <h3>{tableHeader}</h3>
          </Col>
          <Col md={1} mdOffset={8} >
            <CSVExport csvData={logs} />
          </Col>
          <Row>
            <Col md={12}>
              <Table hover bordered striped>
                <thead>
                <tr>
                  {logReportsColumns.map(function(logReportsColumn) {
                    return <th
                      key={logReportsColumn.key}
                      style={{ cursor: "pointer" }}
                    >
                      <WrapperTooltip title={logReportsColumn.title} />
                    </th>
                  })}
                </tr>
                </thead>
                <tbody>
                  {logs.map(function(log) {
                    if (!isFilterAutoEnabled()) {
                      return (
                        <tr key={log.id}>
                          <td>
                            {log.id}
                          </td>
                          <td>
                            {log.created}
                          </td>
                          <td>
                            {log.author}
                          </td>
                          <td>
                            {log.action}
                          </td>
                          <td>
                            {log.item_type}
                          </td>
                          <td>
                            {log.item_type === 'service' && <div>
                              <a href={'/services/'+log.item_id} target={'_blank'}>{log.item_label}</a>
                            </div>
                            }
                            {log.item_type !== 'service' && <div>
                              {log.item_label}
                            </div>
                            }
                          </td>
                          <td>
                            {log.item_type === 'service' && <div>
                              <a href={'/services/'+log.item_id} target={'_blank'}>{log.item_id}</a>
                            </div>
                            }
                            {log.item_type !== 'service' && <div>
                              {log.item_id}
                            </div>
                            }
                          </td>
                          <td>
                            <pre style={preStyle}>{jsonPretty(log.before)}</pre>
                          </td>
                          <td>
                            <pre style={preStyle}>{jsonPretty(log.after)}</pre>
                          </td>
                        </tr>
                      );
                    } else if (isFilterAutoEnabled() && log.author !== '') {
                      return (
                        <tr key={log.id}>
                          <td>
                            {log.id}
                          </td>
                          <td>
                            {log.created}
                          </td>
                          <td>
                            {log.author}
                          </td>
                          <td>
                            {log.action}
                          </td>
                          <td>
                            {log.item_type}
                          </td>
                          <td>
                            {log.item_type === 'service' && <div>
                              <a href={'/services/'+log.item_id} target={'_blank'}>{log.item_label}</a>
                            </div>
                            }
                            {log.item_type !== 'service' && <div>
                              {log.item_label}
                            </div>
                            }
                          </td>
                          <td>
                            {log.item_type === 'service' && <div>
                              <a href={'/services/'+log.item_id} target={'_blank'}>{log.item_id}</a>
                            </div>
                            }
                            {log.item_type !== 'service' && <div>
                              {log.item_id}
                            </div>
                            }
                          </td>
                          <td>
                            <pre style={preStyle}>{jsonPretty(log.before)}</pre>
                          </td>
                          <td>
                            <pre style={preStyle}>{jsonPretty(log.after)}</pre>
                          </td>
                        </tr>
                      );
                    }
                  })}
                </tbody>
              </Table>
            </Col>
          </Row>
        </Col>
      </Row>
    </div>;
  }
}

LogReportsTable.propTypes = {
  logs: PropTypes.array,
  limit: PropTypes.number,
  offset: PropTypes.number
}

export default LogReportsTable;
