import React from "react";
import {Redirect} from "react-router";
import {getUser} from "lib/auth";
import ServiceOwnerView from "./components/ServiceOwnerView";
import LoginComponent from "../Login/LoginComponent";

class ServiceOwnerPage extends React.Component {
  render() {
    let {uid} = this.props.match.params;
    if (!uid) {
      let user = getUser();
      if (user !== "") {
        // redirect to user's view of MyServices if user is found
        return <Redirect to={`/serviceOwner/${user}`}/>;
      } else {
        // force a call to backend to get user-info
        // reload to serve page using correct user-info
        return (
          <div>
            <LoginComponent/>
            <ServiceOwnerView uid={"invalid_user"}/>
            {window.location.reload()}
          </div>
        );
      }
    } else {
      return (
        <div>
          <LoginComponent/>
          <ServiceOwnerView uid={uid}/>
        </div>
      );
    }
  }
}

export default ServiceOwnerPage;
