import React from "react";
import { Panel } from "react-bootstrap";
import { toEmployeeEmail } from "lib/formatters";
import PropTypes from "prop-types";
import { Query } from "react-apollo";
import gql from "graphql-tag";
import { LoadingSpinner } from "../../../components/LoadingSpinner";

const fetchPrimaryOwnerDataQuery = gql`
  query fetchPrimaryOwnerData($user_ids: [ID]!) {
    contacts(user_ids: $user_ids) {
      user_id
      email
      manager_user_id
      manager_preferred_name
      team_name
      bu_name
      org_name
    }
  }
`;

export const ServiceDetailHierarchy = ({ user_ids }) => (
  <Query query={fetchPrimaryOwnerDataQuery} variables={{ user_ids }}>
    {({ loading, error, data}) => {
      if (loading) {
        return <LoadingSpinner />
      }
      if (error) {
        console.log(error);
        console.trace();
        return null
      }
      if (!data || data === undefined || data.length === 0){
        return null;
      }

      var primaryOwnerData = data.contacts[0];

      return (
        <Panel header="Hierarchical Details (based on Primary Owner)">
          <label>Manager: </label> {primaryOwnerData ? primaryOwnerData.manager_preferred_name : ""}<br/>
          <label>Team: </label> {primaryOwnerData ? primaryOwnerData.team_name : ""}<br/>
          <label>Org: </label> {primaryOwnerData ? primaryOwnerData.org_name : ""}<br/>
          <label>BU: </label> {primaryOwnerData ? primaryOwnerData.bu_name : ""}
        </Panel>
      );
    }}
  </Query>
)


ServiceDetailHierarchy.propTypes = {
  user_ids: PropTypes.array,
  loading: PropTypes.bool,
  error: PropTypes.object,
  managers: PropTypes.array,
}

export default ServiceDetailHierarchy;
