import React from "react";
import PropTypes from 'prop-types';
import { Button } from "react-bootstrap";
import UserSelect from "common/User/UserSelect";
import { reduxForm } from "redux-form";
import { UpdateOwnerButtonWrapper } from "./ServiceOwnerTransfer";
import { pencil, cross } from 'react-icons-kit/icomoon'
import { Icon } from "react-icons-kit/Icon";
import {getUserDisplayName} from 'common/User/Util'
import { isEditEnabled } from "./ServiceOwnerTable";

class PrimaryOwner extends React.Component {
  constructor(props) {
    super(props);
    this.state = {isEditing: props.isEditing, newPrimaryOwnerID: props.service.primary_owner_id};
  }
  setNewPrimaryOwner(newPrimaryOwnerID) {
    this.setState(() => {
      return { newPrimaryOwnerID: newPrimaryOwnerID }
    });
  }
  editPrimaryOwner() {
    this.setState(() => {
      return { isEditing: true }
    });
  }
  cancelEdit() {
    this.setState(() => {
      return { isEditing: false, newPrimaryOwnerID: undefined }
    });
  }
  render() {
    if (!this.state.isEditing) {
      return <div>
        {getUserDisplayName(this.props.service.primary_owner)}&nbsp;
        {isEditEnabled() && <div className="pull-right">
          <Button onClick={() => this.editPrimaryOwner()} bsSize="xsmall" bsStyle="warning"><Icon size={12} icon={pencil} /></Button>
        </div>}
      </div>
    } else {
      return <div>
        <UserSelect
          reduxPath={this.props.service.id}
          isEditing={this.state.isEditing}
          user={this.props.service.primary_owner}
          title="New Owner"
          onChange={(event, newValue) => this.setNewPrimaryOwner(newValue)}
          clearable={true}
        />
        <div className="pull-right">
          <UpdateOwnerButtonWrapper service={this.props.service} serviceID={this.props.service.id} newPrimaryOwnerID={this.state.newPrimaryOwnerID} />&nbsp;
          <Button onClick={() => this.cancelEdit()} bsSize="xsmall" bsStyle="danger"><Icon size={12} icon={cross} /></Button>
        </div>
      </div>
    }
  }
}

PrimaryOwner.propTypes = {
  isEditing: PropTypes.bool,
  service: PropTypes.object,
};

const PrimaryOwnerWrapper = reduxForm({
  form: "serviceEdit"
})(PrimaryOwner);

export default PrimaryOwnerWrapper;
