import React from "react";
import { graphql } from "react-apollo";
import PropTypes from "prop-types";
import { Button } from "react-bootstrap";
import Spinner from "react-spinkit";
import { checkmark } from 'react-icons-kit/icomoon'
import { Icon } from "react-icons-kit/Icon";
import {updateServiceQuery} from "common/goracle/actions";

class UpdateOwnerButton extends React.Component {
  constructor(props) {
    super(props);
    this.state = {showLoading: props.showLoading};
  }
  toggleLoading() {
    this.setState(() => {
      return { showLoading: !this.state.showLoading }
    });
  }
  onClick() {
    if (this.props.newPrimaryOwnerID === undefined || this.props.newPrimaryOwnerID === "0") {
      alert("Please specify a valid Primary Owner!");
    } else {
      this.toggleLoading();
      let service = this.props.service;
      service.primary_owner_id = this.props.newPrimaryOwnerID;
      this.props.mutate({
        variables: {
          id: this.props.serviceID,
          service: service,
        },
      }).then(response => {
        window.location.reload();
      }).catch(error => {
        this.toggleLoading();
        console.log("Error:" + error);
        console.trace();
        alert("Failed to update Primary Owner. Error: " + error);
      })
    }
  }
  render() {
    if (this.state.showLoading) {
      return <Spinner name="three-bounce" color="purple"/>
    } else {
      return <Button onClick={() => this.onClick()} bsSize="xsmall" bsStyle="success"><Icon size={12} icon={checkmark} /></Button>;
    }
  }
}

UpdateOwnerButton.propTypes = {
  serviceID: PropTypes.string,
  service: PropTypes.object,
  newPrimaryOwnerID: PropTypes.string,
  isDisabled: PropTypes.bool,
};

export const UpdateOwnerButtonWrapper = graphql(updateServiceQuery)(UpdateOwnerButton);

class UpdateSlackChannelButton extends React.Component {
  constructor(props) {
    super(props);
    this.state = {showLoading: props.showLoading};
  }
  toggleLoading() {
    this.setState(() => {
      return { showLoading: !this.state.showLoading }
    });
  }
  onClick() {
    let { slackChannelID, serviceID } = this.props;
    this.toggleLoading();
    this.props.mutate({
      variables: {
        id: serviceID,
        service: {id: serviceID, slack_channel_id: slackChannelID },
      },
    }).then(response => {
      this.toggleLoading();
      this.props.cancelEdit();
    }).catch(error => {
      this.toggleLoading();
      console.log("Error:" + error);
      console.trace();
      alert("Failed to update SlackChannel. Error: " + error);
    })
  }
  render() {
    if (this.state.showLoading) {
      return <Spinner name="three-bounce" color="purple" noFadeIn/>
    } else {
      return <Button onClick={() => this.onClick()} bsSize="xsmall" bsStyle="success"><Icon size={12} icon={checkmark} /></Button>;
    }
  }
}

UpdateSlackChannelButton.propTypes = {
  serviceID: PropTypes.string,
  slackChannelID: PropTypes.string,
  isDisabled: PropTypes.bool,
};

export const UpdateSlackChannelButtonWrapper = graphql(updateServiceQuery)(UpdateSlackChannelButton);

class UpdateStateButton extends React.Component {
  constructor(props) {
    super(props);
    this.state = {showLoading: props.showLoading};
  }
  toggleLoading() {
    this.setState(() => {
      return { showLoading: !this.state.showLoading }
    });
  }
  onClick() {
    let { serviceState, serviceID } = this.props;
    this.toggleLoading();
    this.props.mutate({
      variables: {
        id: serviceID,
        service: {id: serviceID, state: serviceState },
      },
    }).then(response => {
      this.toggleLoading();
      this.props.cancelEdit();
    }).catch(error => {
      this.toggleLoading();
      console.log("Error:" + error);
      console.trace();
      alert("Failed to update State. Error: " + error);
    })
  }
  render() {
    if (this.state.showLoading) {
      return <Spinner name="three-bounce" color="purple" noFadeIn/>
    } else {
      return <Button onClick={() => this.onClick()} bsSize="xsmall" bsStyle="success"><Icon size={12} icon={checkmark} /></Button>;
    }
  }
}

UpdateStateButton.propTypes = {
  serviceID: PropTypes.string,
  serviceState: PropTypes.string,
  isDisabled: PropTypes.bool,
};

export const UpdateStateButtonWrapper = graphql(updateServiceQuery)(UpdateStateButton);
