import React from "react";
import { Query } from "react-apollo";
import gql from "graphql-tag";
import Spinner from "react-spinkit";
import { getUser } from "lib/auth";
import PropTypes from "prop-types";
import { serviceShallowDataFragment } from "common/goracle/actions";
import ServiceOwnerTable from "./ServiceOwnerTable";
import ErrorDisplay from "components/ErrorDisplay";

const servicesForOwnerQuery = gql `
  query servicesForOwner($uid: String!) {
    servicesForOwner(uid: $uid) {
      ...serviceShallowData
    slack_channel {
      id
      name
    }
      __typename
    }
  }
  ${serviceShallowDataFragment}
`

const ServiceOwnerView = ({ uid }) => (
  <Query query={servicesForOwnerQuery} variables={{ uid }}>
    {({ loading, error, data}) => {
      if (loading) {
        return <Spinner fadeIn={"quarter"} name={"pacman"} color={"purple"}/>
      }
      if (error) {
        console.log(error);
        console.trace();
        return <ErrorDisplay errorMessage={error.message}/>
      }

      let services = data.servicesForOwner;
      if (!services){
        return;
      }
      if (services === undefined || services.length === 0) {
        return <div><h3>Services owned by {uid}</h3><p>{uid} owns no services. Click <a href={"/services/"}>here</a> to search for service(s) that are part of the service catalog.</p></div>
      }
      return <ServiceOwnerTable services={services} uid={uid}/>;
    }}
  </Query>
)


ServiceOwnerView.propTypes = {
  uid: PropTypes.string.isRequired,
  loading: PropTypes.bool,
  error: PropTypes.object,
  services: PropTypes.array,
}

export default ServiceOwnerView;
