import React from 'react'
import { Button } from 'react-bootstrap'
import { Link } from 'react-router-dom'
import Icon from 'react-icons-kit'
import { pencil, cross } from 'react-icons-kit/icomoon'
import { slack } from 'react-icons-kit/fa/slack'
import PropTypes from 'prop-types'
import { toSlack } from 'lib/formatters'
import ServiceSlackChannelDropdown from './ServiceSlackChannelDropdown'
import { UpdateSlackChannelButtonWrapper } from './ServiceOwnerTransfer'
import { isEditEnabled } from "./ServiceOwnerTable";

class ServiceSlackChannel extends React.Component {
  constructor (props) {
    super(props)
    this.cancelEdit = this.cancelEdit.bind(this)
    this.state = {
      isEditing: props.isEditing,
      slackChannelID: props.slackChannel && props.slackChannel.id,
    }
  }

  setSlackChannel(selectedOption) {
    this.setState({
      slackChannelID: selectedOption != null ? selectedOption.id : '',
    })
  }

  editSlackChannel() {
    this.setState({
      isEditing: true
    })
  }

  cancelEdit() {
    this.setState({
      isEditing: false,
      slackChannelID: this.props.slackChannel && this.props.slackChannel.id
    })
  }

  render () {
    let { slackChannel, serviceID } = this.props
    let { slackChannelID } = this.state
    if (!this.state.isEditing) {
      return <div>
        {slackChannel && <Link to={toSlack(slackChannel.id)} target="_blank">
          <Icon icon={slack}/>{slackChannel.name}
        </Link>}&nbsp;
        {isEditEnabled() && <div className="pull-right">
          <Button
            onClick={() => this.editSlackChannel()}
            bsSize="xsmall"
            bsStyle="warning">
            <Icon size={12} icon={pencil}/>
          </Button>
        </div>}
      </div>
    } else {
      return <div>
        <ServiceSlackChannelDropdown
          setSlackChannel={(event) => this.setSlackChannel(event)}
          slackChannelID={slackChannelID}
        />
        <div className="pull-right">
          <UpdateSlackChannelButtonWrapper
            cancelEdit={this.cancelEdit}
            slackChannelID={slackChannelID}
            serviceID={serviceID}
          />&nbsp;
          <Button
            onClick={this.cancelEdit}
            bsSize="xsmall"
            bsStyle="danger">
            <Icon size={12} icon={cross}/>
          </Button>
        </div>
      </div>
    }
  }
}

ServiceSlackChannel.propTypes = {
  isEditing: PropTypes.bool,
  serviceID: PropTypes.string,
  slackChannel: PropTypes.object,
  slackChannels: PropTypes.array,
}

export default ServiceSlackChannel
