import React from 'react'
import gql from 'graphql-tag'
import { graphql } from 'react-apollo'
import Spinner from 'react-spinkit'
import PropTypes from 'prop-types'
import VirtualizedSelect from "react-virtualized-select";

import "react-select/dist/react-select.css";
import "react-virtualized/styles.css";
import "react-virtualized-select/styles.css";

const slackChannelsQuery = gql`
  query slackChannels {
    slack {
      channels {
        name
        id
      }
    }
  }
`

let slackChannelsGqlQuery = graphql(slackChannelsQuery, {
  props: ({ data }) => ({
    loading: data.loading,
    error: data.error,
    slackChannels: data.slack && data.slack.channels,
  }),
})

class ServiceSlackChannelDropdown extends React.Component {
  render () {
    let { error, loading, slackChannels, slackChannelID } = this.props
    if (loading) {
      return <Spinner name="three-bounce" color="purple" noFadeIn/>
    }
    if (error) {
      console.log(error)
      return <div class="text-danger">
        <p>Failed to fetch slack channels, please refresh!</p>
      </div>
    }
    return (
      <VirtualizedSelect
        labelKey={'name'}
        valueKey={'id'}
        value={slackChannelID}
        onChange={(newValue) => {
          this.props.setSlackChannel(newValue)
        }}
        options={slackChannels}
        clearable={true}
      />
    )
  }

}

ServiceSlackChannelDropdown.propTypes = {
  slackChannel: PropTypes.object,
  slackChannels: PropTypes.array,
}

export default slackChannelsGqlQuery(ServiceSlackChannelDropdown)
