import React from 'react'
import { Button } from 'react-bootstrap'
import Icon from 'react-icons-kit'
import { pencil, cross } from 'react-icons-kit/icomoon'
import PropTypes from 'prop-types'
import { UpdateStateButtonWrapper } from "./ServiceOwnerTransfer";
import ServiceStateDropdown from "./ServiceStateDropdown";
import { isEditEnabled } from "./ServiceOwnerTable";

class ServiceState extends React.Component {
  constructor (props) {
    super(props);
    this.cancelEdit = this.cancelEdit.bind(this);
    this.state = {
      isEditing: props.isEditing,
      newServiceState: props.serviceState,
    }
  }

  setServiceState(selectedOption) {
    this.setState({
      newServiceState: selectedOption != null ? selectedOption.value : '',
    })
  }

  editServiceState() {
    this.setState({
      isEditing: true
    })
  }

  cancelEdit() {
    this.setState({
      isEditing: false,
      newServiceState: this.props.serviceState
    })
  }

  render () {
    let { serviceState, serviceID } = this.props;
    let { newServiceState } = this.state;
    if (!this.state.isEditing) {
      return <div>
          {serviceState}
        {isEditEnabled() && <div className="pull-right">
          <Button
            onClick={() => this.editServiceState()}
            bsSize="xsmall"
            bsStyle="warning">
            <Icon size={12} icon={pencil}/>
          </Button>
        </div>}
      </div>
    } else {
      return <div>
        <ServiceStateDropdown
          setServiceState={(event) => this.setServiceState(event)}
          serviceState={newServiceState}
        />
        <div className="pull-right">
          <UpdateStateButtonWrapper
            cancelEdit={this.cancelEdit}
            serviceState={newServiceState}
            serviceID={serviceID}
          />&nbsp;
          <Button
            onClick={this.cancelEdit}
            bsSize="xsmall"
            bsStyle="danger">
            <Icon size={12} icon={cross}/>
          </Button>
        </div>
      </div>
    }
  }
}

ServiceState.propTypes = {
  isEditing: PropTypes.bool,
  serviceID: PropTypes.string,
  serviceState: PropTypes.string,
};

export default ServiceState
