import React from 'react'
import VirtualizedSelect from "react-virtualized-select";

import "react-select/dist/react-select.css";
import "react-virtualized/styles.css";
import "react-virtualized-select/styles.css";

export const serviceStates = [
  { label: "Active", value: "Active" },
  { label: "Inactive", value: "Inactive" },
];

class ServiceStatelDropdown extends React.Component {
  render () {
    let { serviceState } = this.props;
    return (
      <VirtualizedSelect
        optionHeight={50}
        labelKey={'label'}
        valueKey={'value'}
        value={serviceState}
        onChange={(newValue) => {
          this.props.setServiceState(newValue)
        }}
        options={serviceStates}
        clearable={false}
      />
    )
  }
}

export default ServiceStatelDropdown
