import React from "react";
import { IsDevelopment, IsProduction } from "../../../lib/env";
import LoginComponent from "../../Login/LoginComponent";

var prevURL = ""

class BackendWrapperView extends React.Component {

  constructor(props, context) {
    super(props, context);
    prevURL = window.location.href;
  }

  redirectToBackend() {
    if (IsProduction()) {
      window.location.href = prevURL.replace("servicecatalog", "servicecatalog-api");
    } else if (IsDevelopment()) {
      window.location.href = prevURL.replace("servicecatalog-beta", "servicecatalog-api-beta");
    } else {
      window.location.href = prevURL.replace("3000", "8000");
    }
  }

  render() {
    return (
      <div>
        <LoginComponent/>
        {this.redirectToBackend()}
      </div>
    )
  }
}

export default BackendWrapperView;
