import React from "react";
import PropTypes from "prop-types";

class EndpointCheckbox extends React.Component {
  render() {
    const { isEditing, input } = this.props;
    return (
      <input
        type="checkbox"
        checked={input.value}
        onChange={input.onChange}
        disabled={!isEditing}
      />
    );
  }
}

EndpointCheckbox.propTypes = {
  isEditing: PropTypes.bool,
  input: PropTypes.object.isRequired,
};

export default EndpointCheckbox;
