import React from "react";
import PropTypes from "prop-types";

class EndpointNumber extends React.Component {
  render() {
    const { isEditing, input, meta: { error } } = this.props;
    const inputStyle = {
      width: "100%",
      boxSizing: "border-box",
    };
    if (!isEditing) {
      if (input.value === undefined) {
        return <React.Fragment> 1 </React.Fragment>;
      }
      return <React.Fragment> {input.value} </React.Fragment>;
    } else {
      return (
        <React.Fragment>
          <input
            type="number"
            value={input.value}
            onChange={input.onChange}
            style={inputStyle}
          />
          {error && <b>{error}</b>}
        </React.Fragment>
      );
    }
  }
}

EndpointNumber.propTypes = {
  isEditing: PropTypes.bool,
  input: PropTypes.object.isRequired,
  meta: PropTypes.object.isRequired,
};

export default EndpointNumber;
