import React from "react";
import PropTypes from "prop-types";
import { Table, Button, Panel } from "react-bootstrap";
import WrapperTooltip from "components/WrapperTooltip";
import ServiceEndpointsTable from "./ServiceEndpointsTable";
import { reduxForm, FieldArray } from "redux-form";

class ServiceEndpoints extends React.Component {
  render() {
    const { isEditing } = this.props;

    const defaultEndpoint = {
      stage: "beta",
      region: "us-west-2",
      vpc_endpoint_service_id: "unknown",
      hostname: "unknown",
      port: 80,
      ssl_enabled: false,
    };
    const addEndpoint = ({ fields, isEditing }) => (
      <Button bsStyle="primary" onClick={() => fields.push(defaultEndpoint)}>
        Add Endpoint
      </Button>
    );

    const smallHeader = {
      width: "8%",
      whiteSpace: "pre-wrap",
    };
    const bigHeader = {
      width: "30%",
      whiteSpace: "pre-wrap",
    };
    const tableStyle = {
      tableLayout: "fixed",
    };

    return (
      <Panel header="Service Endpoints">
        <Table responsive hover bordered style={tableStyle}>
          <thead>
            <tr>
              <th style={smallHeader}>
                <WrapperTooltip title="Stage" />
              </th>
              <th style={smallHeader}>
                <WrapperTooltip title="Region" />
              </th>
              <th style={bigHeader}>
                <WrapperTooltip
                  title="VPC Endpoint Service Name"
                  tooltipID="VPC Endpoint Name"
                />
              </th>
              <th style={bigHeader}>
                <WrapperTooltip title="Hostname" />
              </th>
              <th style={smallHeader}>
                <WrapperTooltip title="Port" />
              </th>
              <th>
                <WrapperTooltip title="SSL?" tooltipID="SSL Enabled" />
              </th>
              {isEditing && (
                <th>
                  <WrapperTooltip
                    title="Remove?"
                    tooltipID="Remove Endpoint?"
                  />
                </th>
              )}
            </tr>
          </thead>
          <FieldArray
            name="endpoints"
            component={ServiceEndpointsTable}
            isEditing={isEditing}
          />
        </Table>
        {isEditing && (
          <FieldArray
            name="endpoints"
            component={addEndpoint}
            isEditing={isEditing}
          />
        )}
      </Panel>
    );
  }
}

ServiceEndpoints.propTypes = {
  isEditing: PropTypes.bool,
};

var ServiceEndpointsWrapper = reduxForm({
  form: "serviceEdit",
})(ServiceEndpoints);

export default ServiceEndpointsWrapper;
