import React from "react";
import { Button, Glyphicon } from "react-bootstrap";
import PropTypes from "prop-types";
import EndpointString from "./ServiceEndpointString";
import EndpointNumber from "./ServiceEndpointNumber";
import EndpointCheckbox from "./ServiceEndpointCheckbox";
import { Field } from "redux-form";

const normalizeNumber = value => {
  if (!value) {
    return value;
  }
  return isNaN(value) ? 1 : parseInt(value);
};

const normalizeString = value => {
  if (!value) {
    return value;
  }
  return value.replace(/\s/g, "");
};

class ServiceEndpointsTable extends React.Component {
  render() {
    const { fields, isEditing } = this.props;
    const stringTdStyle = {
      wordWrap: "break-word",
    };
    return (
      <tbody>
        {fields.map((endpoint, index) => {
          return (
            <tr key={index}>
              <td style={stringTdStyle}>
                <Field
                  name={`${endpoint}.stage`}
                  component={EndpointString}
                  type="text"
                  isEditing={isEditing}
                  normalize={normalizeString}
                />
              </td>
              <td style={stringTdStyle}>
                <Field
                  name={`${endpoint}.region`}
                  component={EndpointString}
                  type="text"
                  isEditing={isEditing}
                  normalize={normalizeString}
                />
              </td>
              <td style={stringTdStyle}>
                <Field
                  name={`${endpoint}.vpc_endpoint_service_id`}
                  component={EndpointString}
                  type="text"
                  isEditing={isEditing}
                  normalize={normalizeString}
                />
              </td>
              <td style={stringTdStyle}>
                <Field
                  name={`${endpoint}.hostname`}
                  component={EndpointString}
                  type="text"
                  isEditing={isEditing}
                  normalize={normalizeString}
                />
              </td>
              <td>
                <Field
                  name={`${endpoint}.port`}
                  component={EndpointNumber}
                  type="number"
                  isEditing={isEditing}
                  normalize={normalizeNumber}
                />
              </td>
              <td>
                <Field
                  name={`${endpoint}.ssl_enabled`}
                  component={EndpointCheckbox}
                  type="checkbox"
                  isEditing={isEditing}
                />
              </td>
              {isEditing && (
                <td>
                  <Button
                    onClick={() => fields.remove(index)}
                    bsSize="xsmall"
                    bsStyle="danger"
                  >
                    <Glyphicon glyph="remove" />
                  </Button>
                </td>
              )}
            </tr>
          );
        })}
      </tbody>
    );
  }
}

ServiceEndpointsTable.propTypes = {
  isEditing: PropTypes.bool,
  fields: PropTypes.object,
};

export default ServiceEndpointsTable;
