// @format
import React from "react";
import {Col, Panel, Row} from "react-bootstrap";
import {serviceColumns} from "lib/formatters";
import AvailabilityTable from "../../../common/ServiceTable/containers/ServiceContainer";
import Spinner from "react-spinkit";
import ErrorDisplay from "components/ErrorDisplay";

// High level container that either renders a loading
// spinner, an error message, or renders an underlying table
class ServiceList extends React.Component {
  render() {
    let {services, isLoading, hasErrored, error} = this.props;

    if (hasErrored) {
      return <ErrorDisplay errorMessage={error.message}/>
    }
    if (isLoading) {
      return <Spinner name="ball-pulse-rise" color="purple" noFadeIn/>
    }
    return (
      <div>
        <Row>
          <Col md={12}>
            <Panel header="Services">
              <AvailabilityTable
                tableId="servicesIndex"
                data={services}
                dataType="service"
                columns={serviceColumns}
                isLoading={isLoading}
                hasErrored={hasErrored}
              />
            </Panel>
          </Col>
        </Row>
      </div>
    );
  }
}

export default ServiceList;
