import React from "react";
import {Query} from "react-apollo";
import gql from "graphql-tag";
import {LoadingSpinner} from "../../../components/LoadingSpinner";
import {services, trimmedServiceNames} from "./ServiceView";

const servicesQuery = gql`
  query Services {
    services {
      id
      name
    }
  }
`;

// remove whitespaces, special characters and ignore case
export function trimServiceName(input) {
  if (input) {
    return input.replace(/[^A-Z0-9]+/ig, "").toLowerCase()
  }
}

// This component is used to populate the two lists: services & trimmedServiceNames
export const ServiceNames = () => (
  <Query query={servicesQuery}>
    {({loading, error, data}) => {
      if (loading) {
        return <LoadingSpinner/>
      }
      if (error) {
        console.log(error);
        console.trace();
        return null
      }
      if (!data || data === undefined || data.length === 0) {
        return null;
      }
      if (trimmedServiceNames.length === 0) {
        for (let service of data.services) {
          services.push(service);
          let trimmedServiceName = trimServiceName(service.name);
          trimmedServiceNames.push(trimmedServiceName);
        }
      }
      return <div></div>
    }}
  </Query>
);
