import React from "react";
import PropTypes from "prop-types";
import { Field } from "redux-form";
import { Col, ListGroup, ListGroupItem, Panel, Row } from "react-bootstrap";
import FormSelectType from "common/FormFields/components/FormSelectType";
import FormTextArea from "common/FormFields/components/FormTextArea";
import FormText from "common/FormFields/components/FormText";
import { FormUserDataSelectField } from "common/FormFields";
import { Link } from 'react-router-dom'

const storesPersonalDataOptions = [
  { value: true, label: "Yes" },
  { value: false, label: "No" },
];

const requiredResponse = {
  true: [
    {
      value: true,
      label: "Response Required (This service stores user personal data)",
    },
    { value: false, label: "Response Not Required (Legal-Approved Exemption)" },
  ],
  false: [
    {
      value: false,
      label:
        "Response Not Required (This service does not store user personal data)",
    },
  ],
};

class UserDataPrivacy extends React.Component {
  render() {
    const {
      accessExceptionRequired,
      deletionExceptionRequired,
      isEditing,
      storesUserDataSelected,
      setFieldValue,
    } = this.props;

    const handleUserDataOnChange = (_evt, val) => {
      // When the service does not store personal data, access/delete request should be false by default
      // Otherwise set to true
      setFieldValue("access_requests", val);
      setFieldValue("deletion_requests", val);
    };

    return (
      <Panel header="User Data Privacy Requirements">
        <ListGroup fill>
          <ListGroupItem>
            <Row>
              <Col md={isEditing ? 6 : 12}>
                <Field
                  name="stores_user_data"
                  component={FormSelectType}
                  title="Does This Service Store User Personal Data?"
                  customLabelComponent={
                    <Link
                      style={{ fontWeight: 400, margin: "1px 4px" }}
                      to="https://wiki.twitch.com/display/TTV/Privacy"
                      target="_blank"
                    >
                      What is user personal data?
                    </Link>
                  }
                  isEditing={isEditing}
                  options={storesPersonalDataOptions}
                  onChange={handleUserDataOnChange}
                />
              </Col>
            </Row>
          </ListGroupItem>
          {storesUserDataSelected !== undefined && (
            <ListGroupItem>
              <Row>
                <Col md={isEditing ? 6 : 12}>
                  <Field
                    name="access_requests"
                    component={FormSelectType}
                    title="Is This Service Required to Respond to PDMS User Data Access Requests?"
                    infoLink="https://docs.google.com/document/d/1dOdRyepnYNOS6RT7fSTJ2fRmVdfreBYqQhMIV2sIpQQ/edit#heading=h.cbx1y91vvwk1"
                    isEditing={isEditing}
                    options={requiredResponse[storesUserDataSelected]}
                    disabled={!storesUserDataSelected}
                  />
                </Col>
              </Row>
              {accessExceptionRequired && (
                <Row>
                  <Col md={12}>
                    <Field
                      name="access_exception"
                      component={isEditing ? FormTextArea : FormText}
                      type="text"
                      title="Legal-Approved Exception Description"
                      placeholder="Enter description..."
                      isEditing={isEditing}
                      maxLength={1000}
                    />
                  </Col>
                  <Col md={isEditing ? 6 : 12}>
                    <Field
                      name="access_exception_validated_by"
                      component={FormText}
                      type="text"
                      title="Legal-Approved Exception Approved By"
                      placeholder="Enter name..."
                      isEditing={isEditing}
                    />
                  </Col>
                </Row>
              )}
            </ListGroupItem>
          )}
          {storesUserDataSelected !== undefined && (
            <ListGroupItem>
              <Row>
                <Col md={isEditing ? 6 : 12}>
                  <Field
                    name="deletion_requests"
                    placeholder="Enter description..."
                    component={FormSelectType}
                    title="Is This Service Required to Respond to PDMS User Data Deletion Requests?"
                    infoLink="https://docs.google.com/document/d/1dOdRyepnYNOS6RT7fSTJ2fRmVdfreBYqQhMIV2sIpQQ/edit#heading=h.cbx1y91vvwk1"
                    isEditing={isEditing}
                    options={requiredResponse[storesUserDataSelected]}
                    disabled={!storesUserDataSelected}
                  />
                </Col>
              </Row>
              {deletionExceptionRequired && (
                <Row>
                  <Col md={12}>
                    <Field
                      name="deletion_exception"
                      component={isEditing ? FormTextArea : FormText}
                      type="text"
                      title="Legal-Approved Exception Description"
                      isEditing={isEditing}
                      maxLength={1000}
                    />
                  </Col>
                  <Col md={isEditing ? 6 : 12}>
                    <Field
                      name="deletion_exception_validated_by"
                      component={FormText}
                      type="text"
                      title="Legal-Approved Exception Approved By"
                      placeholder="Enter name..."
                      isEditing={isEditing}
                    />
                  </Col>
                </Row>
              )}
            </ListGroupItem>
          )}
          {storesUserDataSelected && (
            <ListGroupItem>
              <FormUserDataSelectField
                name="user_data_types"
                id="userDataTypes"
                dataType="user_data_types"
                isEditing={isEditing}
                setFieldValue={setFieldValue}
              />
            </ListGroupItem>
          )}
        </ListGroup>
      </Panel>
    );
  }
}

UserDataPrivacy.propTypes = {
  isEditing: PropTypes.bool,
};

export default UserDataPrivacy;
