import React from "react";
import { connect } from "react-redux";
import _ from "lodash";
import { serviceCreate } from "../modules/service_list.js";

/*  This is a container component. Notice it does not contain any JSX,
    nor does it import React. This component is **only** responsible for
    wiring in the actions and state necessary to render a presentational
    component - in this case, the counter:   */

import ServiceList from "../components/ServiceList";
import { createService, fetchAllServices } from "common/goracle/actions";
import LoginComponent from "../../Login/LoginComponent";

/*  Object of action creators (can also be function that returns object).
    Keys will be passed as props to presentational components. Here we are
    implementing our wrapper around increment; the component doesn't care   */

class ServiceListContainer extends React.Component {
  componentDidMount() {
    this.props.fetchAllServices();
  }
  // As little presentational logic as possible goes here.
  // Use some basic conditionals to decide which visual components should be rendered
  // based on the current state
  render() {
    return (
      <div>
        <LoginComponent/>
        <ServiceList {...this.props} />
      </div>
    )
  }
}

var mapDispatchToProps = function(dispatch) {
  return {
    servicesFetchData: url => dispatch(servicesFetchData(url)),
    createService: () => dispatch(serviceCreate()),
    fetchAllServices: () => dispatch(fetchAllServices()),
  };
};

var mapStateToProps = function(state) {
  return {
    services: _.filter(_.values(state.goracle.servicesByID).map(s => s.service)),
    isLoading: state.goracle.servicesByID.isFetching,
    hasErrored: state.goracle.servicesByID.hasErrored,
    error: state.goracle.servicesByID.error
  };
};

export default connect(mapStateToProps, mapDispatchToProps)(
  ServiceListContainer
);
