import { combineReducers } from "redux";
import { GetAPIBaseURL } from "lib/env";
import { push } from "react-router-redux";
import { toService } from "lib/formatters";

// ------------------------------------
// Constants
// ------------------------------------
export const SERVICE_AUDIT_MODAL_TOGGLE = "SERVICE_AUDIT_MODAL_TOGGLE";
export const SERVICE_METRIC_MODAL_TOGGLE = "SERVICE_METRIC_MODAL_TOGGLE";

// ------------------------------------
// GraphQL Queries
// ------------------------------------

export function serviceViewReturnToIndex() {
  return dispatch => {
    dispatch(push(toService("")));
    window.location.reload();
  };
}

/*  This is a thunk, meaning it is a function that immediately
    returns a function for lazy evaluation. It is incredibly useful for
    creating async actions, especially when combined with redux-thunk! */

export function serviceAuditModalToggle(enabled, auditType) {
  return {
    type: SERVICE_AUDIT_MODAL_TOGGLE,
    enabled: enabled,
    auditType: auditType,
  };
}

export function serviceMetricModalToggle(enabled, metric) {
  return {
    type: SERVICE_METRIC_MODAL_TOGGLE,
    enabled: enabled,
    metric: metric,
  };
}

// ------------------------------------
// Reducers
// ------------------------------------

// Reducer controlling the visibility and content of a modal
// displaying service audit history
export function serviceAuditModal(
  state = { enabled: false, type: "availability" },
  action
) {
  switch (action.type) {
    case SERVICE_AUDIT_MODAL_TOGGLE:
      return {
        enabled: action.enabled,
        auditType: action.auditType,
      };
    default:
      return state;
  }
}
export function serviceMetricModal(
  state = { enabled: false, type: {} },
  action
) {
  switch (action.type) {
    case SERVICE_METRIC_MODAL_TOGGLE:
      return {
        enabled: action.enabled,
        metric: action.metric,
      };
    default:
      return state;
  }
}

export default combineReducers({
  serviceAuditModal: serviceAuditModal,
  serviceMetricModal: serviceMetricModal,
});
