// @format
import {
  applyMiddleware,
  compose,
  createStore as createReduxStore,
} from "redux";
import thunk from "redux-thunk";
import makeRootReducer from "./reducers";
import { updateLocation } from "./location";
import createHistory from "history/createBrowserHistory";
import { routerMiddleware } from "react-router-redux";
import authMiddleware from "lib/auth.js";
import logger from 'redux-logger';
import { __LOCAL__, __DEV__, __TEST__, __PROD__ } from "lib/env";

const createStore = (initialState = {}) => {
  // ======================================================
  // Middleware Configuration
  // ======================================================
  const history = createHistory();
  const middleware = [thunk, routerMiddleware(history)];
  //uncomment this if you want to see all redux states in the console
  // middleware.push(logger);

  if (__DEV__ || __PROD__) {
    middleware.push(authMiddleware);
  }

  // ======================================================
  // Store Enhancers
  // ======================================================
  const enhancers = [];
  let composeEnhancers = compose;

  if (__DEV__ || __LOCAL__) {
    if (typeof window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ === "function") {
      composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__;
    }
  }

  // ======================================================
  // Store Instantiation and HMR Setup
  // ======================================================
  const store = createReduxStore(
    makeRootReducer(),
    initialState,
    composeEnhancers(applyMiddleware(...middleware), ...enhancers)
  );
  store.asyncReducers = {};

  store.baseURL = "http://localhost:8000";

  if (module.hot) {
    module.hot.accept("./reducers", () => {
      const reducers = require("./reducers").default;
      store.replaceReducer(reducers(store.asyncReducers));
    });
  }

  return { store, history };
};

export default createStore;
