import { combineReducers } from "redux";
import { GetMessagingBaseURL } from "lib/env";
export const REQUEST_SEND_EMAIL = "REQUEST_SEND_EMAIL";
export const SET_MESSAGE_BODY = "SET_MESSAGE_BODY";
export const SET_MESSAGE_SUBJECT = "SET_MESSAGE_SUBJECT";
export const SET_MESSAGE_REPLY_TO = "SET_MESSAGE_REPLY_TO";
export const SET_MESSAGE_SEND_TO = "SET_MESSAGE_SEND_TO";

export function setMessageSendTo(sendTo) {
  return {
    type: SET_MESSAGE_SEND_TO,
    sendTo: sendTo,
  };
}
export function setMessageBody(body) {
  return {
    type: SET_MESSAGE_BODY,
    body: body,
  };
}
export function setMessageSubject(subject) {
  return {
    type: SET_MESSAGE_SUBJECT,
    subject: subject,
  };
}
export function setMessageReplyTo(replyTo) {
  return {
    type: SET_MESSAGE_REPLY_TO,
    replyTo: replyTo,
  };
}

export function sendTo(state = [], action) {
  switch (action.type) {
    case SET_MESSAGE_SEND_TO:
      return action.sendTo;
    default:
      return state;
  }
}

export function messageBody(state = "", action) {
  switch (action.type) {
    case SET_MESSAGE_BODY:
      return action.body;
    default:
      return state;
  }
}
export function messageSubject(state = "", action) {
  switch (action.type) {
    case SET_MESSAGE_SUBJECT:
      return action.subject;
    default:
      return state;
  }
}
export function replyTo(state = "", action) {
  switch (action.type) {
    case SET_MESSAGE_REPLY_TO:
      return action.replyTo;
    default:
      return state;
  }
}

export default combineReducers({
  messageSubject,
  messageBody,
  replyTo,
  sendTo,
});
