// @format
import { combineReducers } from "redux";
import locationReducer from "./location";
import uiReducer from "./uiReducer";
import errorReducer from "../common/ErrorHandling/Reducers";
import messaging from "./messaging";
import { reducer as formReducer } from "redux-form";
import availabilityTableReducer from "../common/ServiceTable/modules/service_table";
import formSelectReducer from "../common/FormFields/modules/form_select";
import formMultiSelectReducer from "../common/FormFields/modules/form_multi_select";
import formAttributeSelectReducer from "../common/FormFields/modules/form_attribute_select";
import formUserDataSelectReducer from "../common/FormFields/modules/form_user_data_select";
import formQuerySelectReducer from "../common/FormFields/modules/form_query_select";
import service_list from "../routes/Services/modules/service_list";
import service_view from "../routes/Services/modules/service_view";
import { routerReducer } from "react-router-redux";
import goracleReducers from "common/goracle/reducers";

export const makeRootReducer = asyncReducers => {
  return combineReducers({
    location: locationReducer,
    routing: routerReducer,
    uiReducer: uiReducer,
    errors: errorReducer,
    form: formReducer,
    availability_table: availabilityTableReducer,
    form_select: formSelectReducer,
    form_multi_select: formMultiSelectReducer,
    form_attribute_select: formAttributeSelectReducer,
    form_user_data_select: formUserDataSelectReducer,
    form_query_select: formQuerySelectReducer,
    goracle: goracleReducers,
    messaging: messaging,
    service_list: service_list,
    service_view: service_view,
    ...asyncReducers,
  });
};

export const injectReducer = (store, { key, reducer }) => {
  if (Object.hasOwnProperty.call(store.asyncReducers, key)) return;

  store.asyncReducers[key] = reducer;
  store.replaceReducer(makeRootReducer(store.asyncReducers));
};

export default makeRootReducer;
