import { combineReducers } from "redux";
import { setMessageReplyTo } from "store/messaging";

export const QUERY_TYPE_SET = "QUERY_TYPE_SET";
export const BRUSH_SET = "BRUSH_SET";
export const TOGGLE_EMAIL_MODAL = "TOGGLE_EMAIL_MODAL";
export const TOGGLE_SERVICE_DEPENDENCY_MODAL =
  "TOGGLE_SERVICE_DEPENDENCY_MODAL";

export function metricQuerySelectedAction(queryType) {
  return {
    type: QUERY_TYPE_SET,
    queryType: queryType,
  };
}
export function brushSetAction(brushBegin, brushEnd) {
  return {
    type: BRUSH_SET,
    brushBegin: brushBegin,
    brushEnd: brushEnd,
  };
}

export function toggleMessagingModal(open, type, titleFunc, defaultReplyTo) {
  return {
    type: TOGGLE_EMAIL_MODAL,
    open: open,
    messageType: type,
    titleFunc: titleFunc,
  };
}

export function toggleServiceDependencyModal(open, serviceID) {
  return {
    type: TOGGLE_SERVICE_DEPENDENCY_MODAL,
    open: open,
    serviceID: serviceID,
  };
}

export function queryType(state = "", action) {
  switch (action.type) {
    case QUERY_TYPE_SET:
      return action.queryType;
    default:
      return state;
  }
}
export function brush(state = {}, action) {
  switch (action.type) {
    case BRUSH_SET:
      return {
        begin: action.brushBegin,
        end: action.brushEnd,
      };
    default:
      return state;
  }
}
export function messagingModal(
  state = {
    open: false,
    messageType: "email",
    titleFunc: () => "",
    defaultReplyTo: "",
  },
  action
) {
  let noop = () => "";
  switch (action.type) {
    case TOGGLE_EMAIL_MODAL:
      return {
        open: action.open,
        messageType: action.messageType || "email",
        titleFunc: action.titleFunc || noop,
      };
    default:
      return state;
  }
}

export function serviceDependencyModal(
  state = { open: false, serviceID: 0 },
  action
) {
  switch (action.type) {
    case TOGGLE_SERVICE_DEPENDENCY_MODAL:
      return {
        open: action.open,
        serviceID: action.serviceID,
      };
    default:
      return state;
  }
}

export default combineReducers({
  queryType,
  brush,
  messagingModal,
  serviceDependencyModal,
});
