variable "beanstalk_application_name" {
  default     = "tinker"
}

module "tinker-bs-beta-int" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-aws"
  eb_application_name = "${var.beanstalk_application_name}"
  vpc_id = "vpc-0d8552c5ef867fb71"
  ec2_subnet_ids = "subnet-09f75c37213aaf971,subnet-05145b13551d5c1ac,subnet-025e63c66db73a27e"
  elb_subnet_ids = "subnet-09f75c37213aaf971,subnet-05145b13551d5c1ac,subnet-025e63c66db73a27e"
  elb_loadbalancer_security_groups = "sg-0a5e81ea43b616053"
  auto_scaling_lc_security_groups = "sg-0a5e81ea43b616053"
  auto_scaling_lc_iam_instance_profile = "${aws_iam_role.bs.id}"
  elb_loadbalancer_ssl_cert = "arn:aws:acm:us-west-2:060142377351:certificate/b83d53c2-019f-46db-96e7-c6053520beb7"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.5 running Docker 18.06.1-ce"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "oe-tools@justin.tv"
  service = "availability/tinker"
  env = "beta"
  associate_public_address = "false"
  cname_prefix = "tinker-bs-beta-int"
  common_name = "tinker-bs-beta-int"
  hms_base = "https://hms-esk-development.internal.justin.tv/v1"
  #TODO: update after completing fultonized service catalog infra setup and the endpoint is available
  api_base = "https://servicecatalog-api-beta.internal.justin.tv/api/v2/query.guardian"
  messaging_base = "https://servicecatalog-api.internal.justin.tv/messaging"
  redirect_url = "https://catalog-beta.xarth.tv"
  permanent_redirect = "false"
}
