variable "beanstalk_application_name" {
  default     = "tinker"
}

module "tinker-bs-development-int" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-dev"
  eb_application_name = "${var.beanstalk_application_name}"
  vpc_id = "vpc-a19ca9c5"
  ec2_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  elb_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  elb_loadbalancer_security_groups = "sg-e55f4f83"
  auto_scaling_lc_security_groups = "sg-e55f4f83"
  auto_scaling_lc_iam_instance_profile = "${aws_iam_role.bs.id}"
  elb_loadbalancer_ssl_cert = "arn:aws:acm:us-west-2:386434559102:certificate/588bde5e-2054-47ad-afe5-82e4b4ab656d"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.5 running Docker 18.06.1-ce"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "oe-tools@justin.tv"
  service = "availability/tinker"
  env = "development"
  associate_public_address = "false"
  cname_prefix = "tinker-bs-development-int"
  common_name = "tinker-bs-development-int"
  api_base = "https://servicecatalog-api-dev.internal.justin.tv/api/v2/query.guardian"
  hms_base = "https://hms-esk-development.internal.justin.tv/v1"
  messaging_base = "https://servicecatalog-api-dev.internal.justin.tv/messaging"
}

module "tinker-bs-development-ext" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-dev"
  eb_application_name = "${var.beanstalk_application_name}"
  vpc_id = "vpc-a19ca9c5"
  ec2_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  elb_subnet_ids = "subnet-041c4760,subnet-47e99931,subnet-3f41f267"
  elb_loadbalancer_security_groups = "sg-0f277a34084fecdda"
  auto_scaling_lc_security_groups = "sg-e55f4f83"
  elb_loadbalancer_ssl_cert = "arn:aws:acm:us-west-2:386434559102:certificate/588bde5e-2054-47ad-afe5-82e4b4ab656d"
  auto_scaling_lc_iam_instance_profile = "${aws_iam_role.bs.id}"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.5 running Docker 18.06.1-ce"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "oe-tools@justin.tv"
  service = "availability/tinker"
  env = "development"
  associate_public_address = "false"
  cname_prefix = "tinker-bs-development-ext"
  common_name = "tinker-bs-development-ext"
  elb_scheme = "public"
  api_base = "https://servicecatalog-api-dev.internal.justin.tv/api/v2/query.guardian"
  hms_base = "https://hms-esk-development.internal.justin.tv/v1"
  messaging_base = "https://servicecatalog-api-dev.internal.justin.tv/messaging"
}
