resource "aws_elastic_beanstalk_environment" "bs" {
  name         = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-env"
  description  = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  application  = "${var.eb_application_name}"
  tier         = "WebServer"
  solution_stack_name = "${var.solution_stack_name}"
  application         = "${var.eb_application_name}"

  cname_prefix = "${coalesce(var.cname_prefix, null_resource.vars.triggers.cn)}"

  tags {
    Name        = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
    Environment = "${var.env}"
    Service     = "${var.service}"
    Owner       = "${var.owner}"
    Skeleton    = "dta/docker-eb-tf-skeleton@02678a01b0e4f36187293cb6a1b232a6e3eed783"
  }

  wait_for_ready_timeout = "${var.wait_for_ready_timeout}"

  # Vpc  and network related settings
  setting {
    namespace = "aws:ec2:vpc"
    name      = "VPCId"
    value     = "${var.vpc_id}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "Subnets"
    value     = "${var.ec2_subnet_ids}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "ELBSubnets"
    value     = "${var.elb_subnet_ids}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "AssociatePublicIpAddress"
    value     = "${var.associate_public_address}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "ELBScheme"
    value     = "${var.elb_scheme}"
  }

  # Load Balancer Related Settings
  setting {
    namespace = "aws:elb:loadbalancer"
    name      = "SecurityGroups"
    value     = "${var.elb_loadbalancer_security_groups}"
  }

  setting {
    namespace = "aws:elb:loadbalancer"
    name      = "ManagedSecurityGroup"
    value     = "${var.elb_loadbalancer_security_groups}"
  }

  # asg launch configuration settings
  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "IamInstanceProfile"
    value     = "${coalesce(var.auto_scaling_lc_iam_instance_profile, aws_iam_instance_profile.bs.name)}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "InstanceType"
    value     = "${var.auto_scaling_lc_instance_type}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "MonitoringInterval"
    value     = "${var.auto_scaling_lc_monitoring_interval}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "SecurityGroups"
    value     = "${var.auto_scaling_lc_security_groups}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeType"
    value     = "${var.auto_scaling_lc_root_volume_type}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeSize"
    value     = "${var.auto_scaling_lc_root_volume_size}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "RootVolumeIOPS"
    value     = "${var.auto_scaling_lc_root_volume_iops}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "ENV_NAME"
    value     = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}-env"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "APP"
    value     = "${var.eb_application_name}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "STATSD_HOST_PORT"
    value     = "${var.statsd_host}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "ENVIRONMENT"
    value     = "${var.env}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "API_BASE"
    value     = "${var.api_base}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "HMS_BASE"
    value     = "${var.hms_base}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "MESSAGING_BASE"
    value     = "${var.messaging_base}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "REDIRECT_URL"
    value     = "${var.redirect_url}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "PERMANENT_REDIRECT"
    value     = "${var.permanent_redirect}"
  }

  # eb environment settings
  setting {
    namespace = "aws:elasticbeanstalk:environment"
    name      = "ServiceRole"
    value     = "${var.eb_environment_service_role}"
  }

  setting {
    namespace = "aws:elb:loadbalancer"
    name      = "SSLCertificateId"
    value     = "${var.elb_loadbalancer_ssl_cert}"
  }


  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "DeploymentPolicy"
    value     = "Rolling"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "BatchSizeType"
    value     = "Percentage"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "BatchSize"
    value     = "50"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "RollingUpdateEnabled"
    value     = "true"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "MaxBatchSize"
    value     = "1"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "MinInstancesInService"
    value     = "1"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "RollingUpdateType"
    value     = "Health"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "Timeout"
    value     = "PT10M"
  }

  setting {
    namespace = "aws:elasticbeanstalk:healthreporting:system"
    name      = "SystemType"
    value     = "enhanced"
  }

  # CloudWatch log streaming setup
  setting {
    namespace = "aws:elasticbeanstalk:cloudwatch:logs"
    name      = "StreamLogs"
    value     = "true"
  }

  setting {
    namespace = "aws:elasticbeanstalk:cloudwatch:logs"
    name      = "DeleteOnTerminate"
    value     = "false"
  }

  setting {
    namespace = "aws:elasticbeanstalk:cloudwatch:logs"
    name      = "RetentionInDays"
    value     = "90"
  }
}
