variable "beanstalk_application_name" {
  default     = "tinker"
}

module "tinker-bs-prod-int" {
  source = "../modules/tf_beanstalk_webserver_env"
  eb_application_name = "${var.beanstalk_application_name}"
  vpc_id = "vpc-0c297f6fb11aa79b1"
  ec2_subnet_ids = "subnet-0d0aac8d64c214500,subnet-07bb56d13fa6fa6e2,subnet-0405678cc750dcc16"
  elb_subnet_ids = "subnet-0d0aac8d64c214500,subnet-07bb56d13fa6fa6e2,subnet-0405678cc750dcc16"
  elb_loadbalancer_security_groups = "sg-07416eb15eff286ea"
  auto_scaling_lc_security_groups = "sg-07416eb15eff286ea"
  auto_scaling_lc_iam_instance_profile = "${aws_iam_role.bs.id}"
  elb_loadbalancer_ssl_cert = "arn:aws:acm:us-west-2:619129220317:certificate/bb3e40aa-b73a-478c-bd87-791df9d48ebe"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.10 running Docker 18.06.1-ce"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "oe-tools@justin.tv"
  service = "availability/tinker"
  env = "prod"
  associate_public_address = "false"
  cname_prefix = "tinker-bs-prod-int"
  common_name = "tinker-bs-prod-int"
  hms_base = "https://hms-esk-development.internal.justin.tv/v1"
  #TODO: update after completing fultonized service catalog infra setup and the endpoint is available
  api_base = "https://servicecatalog-api-prod.internal.justin.tv/api/v2/query.guardian"
  messaging_base = "https://servicecatalog-api-prod.internal.justin.tv/messaging"
}
