variable "iam_instance_profile" {
  description = "IAM Instance Profile for the Beanstalk"
  default = "servicecatalog-tinker-production"
}

resource "aws_iam_role" "bs" {
  name = "${var.iam_instance_profile}"
  path = "/"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": { "Service": "ec2.amazonaws.com"},
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "bs" {
  name   = "${var.iam_instance_profile}"
  role   = "${aws_iam_role.bs.id}"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "BucketAccess",
      "Action": [
        "s3:Get*",
        "s3:List*",
        "s3:PutObject"
      ],
      "Effect": "Allow",
      "Resource": [
        "arn:aws:s3:::elasticbeanstalk-*",
        "arn:aws:s3:::elasticbeanstalk-*/*"
      ]
    },
    {
      "Action": [
        "logs:CreateLogStream",
        "logs:DescribeLogStreams",
        "logs:CreateLogGroup",
        "logs:PutLogEvents"
        ],
      "Effect": "Allow",
      "Resource": ["*"]
    },
    {
        "Sid": "FultonContactServiceAccess",
        "Effect": "Allow",
        "Action": "lambda:InvokeFunction",
        "Resource": "arn:aws:lambda:us-west-2:117703951204:function:MyFultonContactsServiceLambda-LambdaFunction-1FXZU65CZ6XXT"
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "bs" {
  depends_on = ["aws_iam_role.bs"]
  name       = "${var.iam_instance_profile}"
  role       = "${aws_iam_role.bs.name}"
}

resource "aws_iam_role_policy_attachment" "attach-old-email-ses-perms" {
    policy_arn = "arn:aws:iam::aws:policy/AmazonSESFullAccess"
    role       = "${aws_iam_role.bs.name}"
}

resource "aws_iam_role_policy" "servicecatalog_tinker_sandstorm_dev_policy" {
  name = "sandstorm-production-tinker-team"
  role = "${aws_iam_role.bs.name}"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Effect": "Allow",
      "Resource": "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/tinker-production"
    },
    {
      "Effect": "Allow",
      "Action": "s3:GetObject",
      "Resource": "arn:aws:s3:::twitch-sandstorm/sandstorm-agent.rpm"
    }
  ]
}
EOF
}
