variable "account" { default = "twitch-central-aws" }
variable "region" { default = "us-west-2" }
variable "pagerduty_cloudwatch_endpoint" { default = "https://events.pagerduty.com/integration/0ca002d01dee49cfa2aee0df8e534f57/enqueue" }

# Setup AWS account
provider "aws" {
  alias = "${var.account}"
  region = "${var.region}"
  profile = "${var.account}"
}

# SNS Topic for the ELB - We are choosing to consolidate the tinker alerts with goracle alerts.
resource "aws_sns_topic" "alert_sns" {
  provider = "aws.${var.account}"
  name = "goracle-production-monitoring"
}

# Subscribe PagerDuty to the SNS Topic
resource "aws_sns_topic_subscription" "pagerduty_sns_subscription" {
  provider = "aws.${var.account}"
  topic_arn = "${aws_sns_topic.alert_sns.arn}"
  protocol = "https"
  endpoint = "${var.pagerduty_cloudwatch_endpoint}"
  endpoint_auto_confirms = true
}

# Alert when the environment is WARN or worse for 3 minutes
resource "aws_cloudwatch_metric_alarm" "elb_healthy_backends_alarm_int" {
  provider = "aws.${var.account}"
  alarm_name = "tinker-production-environment-health-int"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "3"
  metric_name = "EnvironmentHealth"
  namespace = "AWS/ElasticBeanstalk"
  period = "60"
  statistic = "Average"
  threshold = "20"
  alarm_description = "Alert when the environment is WARN or worse for 3 minutes"
  alarm_actions = ["${aws_sns_topic.alert_sns.arn}"]
  ok_actions = ["${aws_sns_topic.alert_sns.arn}"]
  dimensions {
    EnvironmentName = "${module.tinker-bs-production-int.beanstalk_environment_name}"
  }
}

# Alert when the environment is WARN or worse for 3 minutes
resource "aws_cloudwatch_metric_alarm" "elb_healthy_backends_alarm_ext" {
  provider = "aws.${var.account}"
  alarm_name = "tinker-production-environment-health-ext"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "3"
  metric_name = "EnvironmentHealth"
  namespace = "AWS/ElasticBeanstalk"
  period = "60"
  statistic = "Average"
  threshold = "20"
  alarm_description = "Alert when the environment is WARN or worse for 3 minutes"
  alarm_actions = ["${aws_sns_topic.alert_sns.arn}"]
  ok_actions = ["${aws_sns_topic.alert_sns.arn}"]
  dimensions {
    EnvironmentName = "${module.tinker-bs-production-ext.beanstalk_environment_name}"
  }
}
