variable "beanstalk_application_name" {
  default     = "tinker"
}

module "tinker-bs-production-int" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-aws"
  eb_application_name = "${var.beanstalk_application_name}"
  vpc_id = "vpc-bda8eed9"
  ec2_subnet_ids = "subnet-1a87f07e,subnet-0eb83678,subnet-828650da"
  elb_subnet_ids = "subnet-1a87f07e,subnet-0eb83678,subnet-828650da"
  elb_loadbalancer_security_groups = "sg-1825527e"
  auto_scaling_lc_security_groups = "sg-1825527e"
  auto_scaling_lc_iam_instance_profile = "${aws_iam_role.bs.id}"
  elb_loadbalancer_ssl_cert = "arn:aws:acm:us-west-2:007917851548:certificate/71421358-086f-4202-8524-286345a8bd44"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.5 running Docker 18.06.1-ce"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "oe-tools@justin.tv"
  service = "availability/tinker"
  env = "production"
  associate_public_address = "false"
  cname_prefix = "tinker-bs-production-int"
  common_name = "tinker-bs-production-int"
  api_base = "https://servicecatalog-api.internal.justin.tv/api/v2/query.guardian"
  hms_base = "https://hms-esk-production.internal.justin.tv/v1"
  messaging_base = "https://servicecatalog-api.internal.justin.tv/messaging"
  redirect_url = "https://catalog.xarth.tv"
  permanent_redirect = "false"
}

module "tinker-bs-production-ext" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-central-aws"
  eb_application_name = "${var.beanstalk_application_name}"
  vpc_id = "vpc-bda8eed9"
  ec2_subnet_ids = "subnet-1a87f07e,subnet-0eb83678,subnet-828650da"
  elb_subnet_ids = "subnet-e487f080,subnet-0cb8367a,subnet-818650d9"
  elb_loadbalancer_security_groups = "sg-0c9dc76b8b347ad96"
  auto_scaling_lc_security_groups = "sg-1825527e"
  elb_loadbalancer_ssl_cert = "arn:aws:acm:us-west-2:007917851548:certificate/71421358-086f-4202-8524-286345a8bd44"
  auto_scaling_lc_iam_instance_profile = "${aws_iam_role.bs.id}"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.5 running Docker 18.06.1-ce"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "oe-tools@justin.tv"
  service = "availability/tinker"
  env = "production"
  associate_public_address = "false"
  cname_prefix = "tinker-bs-production-ext"
  common_name = "tinker-bs-production-ext"
  elb_scheme = "public"
  api_base = "https://servicecatalog-api.internal.justin.tv/api/v2/query.guardian"
  hms_base = "https://hms-esk.internal.justin.tv/v1"
  messaging_base = "https://servicecatalog-api.internal.justin.tv/messaging"
}
