import React from "react";

import ErrorModal from "common/ErrorHandling/ErrorModal";
import { reportError } from "common/ErrorHandling/Actions";
import createStore from "store/createStore";

jest.useFakeTimers();
jest.mock("lib/graphql");

describe("ErrorModal integration", () => {
  test("Hidden if no errors", () => {
    let store = createStore({}).store;

    const component = shallow(<ErrorModal store={store} />).dive();
    expect(component).toMatchSnapshot();
  });

  test("Shows error without list if one error", () => {
    let store = createStore({}).store;

    store.dispatch(reportError("Error Encountered"));
    const component = shallow(<ErrorModal store={store} />).dive();
    expect(component).toMatchSnapshot();
  });

  test("Shows error with list if more than one error", () => {
    let store = createStore({}).store;

    store.dispatch(reportError("Error Encountered"));
    store.dispatch(reportError("Another error Encountered"));
    store.dispatch(reportError("Last error Encountered"));
    const component = shallow(<ErrorModal store={store} />).dive();
    expect(component).toMatchSnapshot();
  });
});
