import React from "react";

import UserInfoPopover from "common/User/UserView/UserInfoPopover";
import { reportError } from "common/ErrorHandling/Actions";

jest.useFakeTimers();
jest.mock("lib/graphql");

describe("UserInfoPopover", () => {
  test("Shown if user is not undefined", () => {
    const trigger = <p>Guacamole</p>,
      id = "test-id";

    let user = {
      cn: "test user",
      preferred_name: "preferred user",
      building_name: "SFO18",
      uid: "tuser",
      department: "tdepartment",
      manager: "cn=test manager,",
      amazon_uid: "tauser",
      slack: {
        id: "slack777",
        name: "slackUserName",
        realname: "slack real name",
      }
    };

    const component = shallow(
      <UserInfoPopover id={id} user={user} trigger={trigger} />
    );
    component.simulate("click");
    expect(component).toMatchSnapshot();
  });
});
