import React from "react";

import UserView from "common/User/UserView/UserView";
import { reportError } from "common/ErrorHandling/Actions";

jest.useFakeTimers();
jest.mock("lib/graphql");

describe("UserView", () => {
  test("Shown if user is not undefined", () => {
    const trigger = <p>Guacamole</p>,
      id = "test-id";

    let user = {
      cn: "test user",
      preferred_name: "preferred user",
      building_name: "SFO18",
      uid: "tuser",
      department: "tdepartment",
      manager: "cn=test manager,",
      amazon_uid: "tauser",
    };

    const component = shallow(
      <UserView id={id} title="primary owner" user={user} trigger={trigger} />
    );
    component.simulate("click");
    expect(component).toMatchSnapshot();
  });
  test("not shown if user is undefined", () => {
    const trigger = <p>Guacamole</p>,
      id = "test-id";

    let user;

    const component = shallow(
      <UserView id={id} title="primary owner" user={user} trigger={trigger} />
    );
    component.simulate("click");
    expect(component).toMatchSnapshot();
  });
});
