import configureMockStore from "redux-mock-store";
import thunk from "redux-thunk";

import * as actions from "common/goracle/actions";

jest.mock("lib/graphql");

const middlewares = [thunk];
const mockStore = configureMockStore(middlewares);

afterEach(() => {
  fetch.reset();
  fetch.restore();
});

const requestedServiceActions = [
  {
    type: actions.REQUEST_SERVICE,
  },
  {
    type: actions.RECEIVE_SERVICE,
  },
];

describe("goracle async actions", () => {
  test("fetchService creates REQUEST_SERVICE and RECEIVE_SERVICE when done", () => {
    expect.assertions(1);

    const expectedActions = requestedServiceActions;

    const store = mockStore({});
    return store.dispatch(actions.fetchService(1)).then(() => {
      expect(store.getActions()).toMatchObject(expectedActions);
    });
  });

  test("fetchServiceIfNeeded fetches if no entry", () => {
    expect.assertions(1);

    const expectedActions = requestedServiceActions;

    const store = mockStore({ goracle: { servicesByID: {} } });
    return store.dispatch(actions.fetchServiceIfNeeded(1)).then(() => {
      expect(store.getActions()).toMatchObject(expectedActions);
    });
  });

  test("fetchServiceIfNeeded does not fetch if already fetching", () => {
    expect.assertions(1);

    const expectedActions = [];

    const store = mockStore({
      goracle: {
        servicesByID: {
          1: {
            isFetching: true,
          },
        },
      },
    });
    return store.dispatch(actions.fetchServiceIfNeeded(1)).then(() => {
      expect(store.getActions()).toMatchObject(expectedActions);
    });
  });

  test("fetchServiceIfNeeded fetches if not detailed", () => {
    expect.assertions(1);

    const expectedActions = requestedServiceActions;

    const store = mockStore({
      goracle: {
        servicesByID: {
          1: {
            isFetching: false,
            detailed: false,
          },
        },
      },
    });
    return store.dispatch(actions.fetchServiceIfNeeded(1)).then(() => {
      expect(store.getActions()).toMatchObject(expectedActions);
    });
  });

  test("createService creates RECEIVE_SERVICE when done", () => {
    expect.assertions(1);

    const expectedActions = [
      {
        type: actions.RECEIVE_SERVICE,
      },
    ];
    const store = mockStore({ id: "1" });
    return store.dispatch(actions.createService({})).then(() => {
      expect(store.getActions()).toMatchObject(expectedActions);
    });
  });

  test("updateService creates RECEIVE_SERVICE when done", () => {
    expect.assertions(1);

    const expectedActions = [
      {
        type: actions.RECEIVE_SERVICE,
      },
    ];
    const store = mockStore({});
    return store.dispatch(actions.updateService({ id: "1" })).then(() => {
      expect(store.getActions()).toMatchObject(expectedActions);
    });
  });

  test("deleteService creates RECEIVE_SERVICE when done", () => {
    expect.assertions(1);

    const expectedActions = [
      {
        type: actions.RECEIVE_SERVICE,
      },
    ];
    const store = mockStore({});
    return store.dispatch(actions.deleteService({ id: "1" })).then(() => {
      expect(store.getActions()).toMatchObject(expectedActions);
    });
  });
});
