// Integration tests for ServiceList
import React from "react";
import TestRenderer from "react-test-renderer";
import { Provider } from "react-redux";
import { ApolloProvider } from "react-apollo";
import MockRouter from "react-mock-router";

import ServiceOwnerView from "routes/ServiceOwners/components/ServiceOwnerView";
import ServiceOwnerAudit from '../../src/routes/ServiceOwners/components/ServiceAudit'
import createStore from "store/createStore";

// This is an integration test that renders the full component and all dependencies
// For an example component test, see ServiceList

// This is how we mock with Jest. This redirects calls to lib/graphql to lib/__mocks__/graphql.js
jest.mock("lib/graphql");

import { addMockGQLObject, removeMockGQLObject, graphqlClient, graphqlGetHistory, graphqlResetHistory } from "lib/graphql";

// Tests will fail if this is not added. The test renderer does not know about window.createobjectURL unless this is done
Object.defineProperty(window.URL, 'createObjectURL', {
  writable: false,
  value: (x) => {return "mocked_Link_to_download"}
})
describe("ServiceOwnerView integration", () => {
  test("renders ServiceOwnerView given a store", () => {
    let store = createStore({}).store;
    // Use Snapshots to use general sanity checks
    // Wrap with provider to make sure store gets passed to all child components
    const component = TestRenderer.create(
      <MockRouter>
        <Provider store={store}>
          <ApolloProvider client={graphqlClient}>
            <ServiceOwnerView uid={"anubhaws"} />
          </ApolloProvider>
        </Provider>
      </MockRouter>
    );
    let tree = component.toJSON();
    expect(tree).toMatchSnapshot();

    return flushAllPromises().then(() => {
      let tree = component.toJSON();
      expect(tree).toMatchSnapshot();
    });
  });
});
