// Test ServiceList page
// This is a good example of how to use shallow to do shallow rendering to test just this components behavior
// It also shows you how to use enzyme to find and assert on specific elements
import React from "react";
import ServiceList from "routes/Services/components/ServiceList";
import AvailabilityTable from "common/ServiceTable/containers/ServiceContainer";

describe("ServiceList component", () => {
  it("Props are passed through to Availability Table", () => {
    const props = {
      services: [{name: 1}],
      isLoading: false,
      hasErrored: false,
      createService: jest.fn(),
    };
    const wrapper = shallow(<ServiceList {...props} />);
    let aTable = wrapper.findWhere(n => n.type() === AvailabilityTable);
    expect(aTable.length).toEqual(1);
    let aTableProps = aTable.props();
    expect(aTableProps.data).toEqual(props.services);
    expect(aTableProps.isLoading).toEqual(props.isLoading);
    expect(aTableProps.hasErrored).toEqual(props.hasErrored);

    let columns = aTableProps.columns.map(c => c.key);
    expect(columns).toEqual(["name", "primary_owner.cn", "state", "tier", "primary_owner.slack", "primary_owner.manager", "team_name", "org_name", "bu_name", "latest_service_audits", "attributes"]);

  });
});
