// Test ServiceView page
import React from "react";
import { ServiceView } from "routes/Services/components/ServiceView";
import thunk from "redux-thunk";
import renderer from "react-test-renderer";

import configureMockStore from "redux-mock-store";

const middlewares = [thunk];
const mockStore = configureMockStore(middlewares);

const defaultProps = {
  createService: function() {},
  createServiceAudit: function() {},
  updateService: function() {},
  deleteService: function() {},
  toggleServiceAuditModal: function() {},
  serviceAuditModal: {},
  isEditing: false,
  reset: function() {},
  serviceID: "1",
};

describe("ServiceView component", () => {
  it("renders loading spinner when loading", () => {
    const store = mockStore({});

    const props = {
      store: store,
      isFetching: true,
      ...defaultProps,
    };
    const wrapper = shallow(<ServiceView {...props} />);
    expect(wrapper).toMatchSnapshot();
  });

  it("renders error if service undefined and not fetching", () => {
    const store = mockStore({});

    const props = {
      store: store,
      isFetching: false,
      ...defaultProps,
    };
    const wrapper = shallow(<ServiceView {...props} />);
    expect(wrapper).toMatchSnapshot();
  });

  it("renders with service data", () => {
    const store = mockStore({});

    const props = {
      store: store,
      service: { id: "1" },
      ...defaultProps,
    };
    const wrapper = shallow(<ServiceView {...props} />);
    expect(wrapper).toMatchSnapshot();
  });
});
