// Test ServiceViewContainer
import React from "react";

import ConnectedServiceViewContainer, {
  ServiceViewContainer,
} from "routes/Services/containers/ServiceViewContainer";

jest.mock("common/goracle/actions");

const defaultProps = {
  match: {
    params: {
      id: "1",
    },
  },
  isEditing: false,
  hasErrored: false,
  serviceState: "Active",
  serviceID: "1",
  stores_user_data: true,
  access_requests: false,
  access_exception:
    "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In sed magna nec odio bibendum malesuada nec ut dui",
  access_exception_validated_by: "Test 2",
  deletion_requests: true,
  deletion_exception: "",
  deletion_exception_validated_by: "",
  user_data_types: [
    {
      id: "25",
      label: "Moderation Information",
      description: "",
      parent_type: null,
    },
    {
      id: "50",
      label: "Viewing SLAs",
      description: "Jarvis metrics",
      parent_type: {
        id: "49",
        label: "Add Custom Data Type",
      },
    },
    {
      id: "51",
      label: "",
      description: "Viewing metrics",
      parent_type: {
        id: "48",
        label: "Other User Behavior",
      },
    },
    {
      id: "56",
      label: "custom label",
      description: "custom desc",
      parent_type: {
        id: "49",
        label: "Add Custom Data Type",
      },
    },
  ],
};

describe("ServiceViewContainer", () => {
  test("renders ServiceView given a store", () => {
    // In this test, execute with the Connected container to make sure stuff
    // executes
    const props = {
      ...defaultProps,
      hasErrored: false,
    };

    // Using dive to skip past wrapper so that code actually gets run
    const wrapper = shallowWithStore(
      <ConnectedServiceViewContainer {...props} />,
      makeMockStore()
    );
    expect(wrapper.dive()).toMatchSnapshot();
  });

  it("calls formInitialize once if ID changes", () => {
    // Don't use the connected container in this place, using shallow and mock
    // stores and dives is super complex.

    // Do NOT use the action creator mocks here, these need to be the result of
    // matchDispatchToProps which are the actual functions.

    const mockFormInitialize = jest.fn();
    const mockFetchServiceIfNeeded = jest
      .fn()
      .mockReturnValue(new Promise(function() {}));

    const props = {
      ...defaultProps,
      servicesByID: {
        "1": {
          service: {},
        },
        "2": {
          service: {},
        },
      },
      fetchServiceIfNeeded: mockFetchServiceIfNeeded,
      formInitialize: mockFormInitialize,
      match: {
        params: {
          id: "1",
        },
      },
    };

    const wrapper = shallow(<ServiceViewContainer {...props} />);
    expect(mockFetchServiceIfNeeded.mock.calls.length).toBe(1);
    expect(wrapper).toMatchSnapshot();

    mockFormInitialize.mockClear();
    wrapper.setProps({
      match: {
        params: {
          id: "2",
        },
      },
    });
    expect(mockFormInitialize.mock.calls.length).toBe(1);

    // Validate that we're actually properly changing service ID of child view
    expect(wrapper).toMatchSnapshot();
  });
});
