import thunk from "redux-thunk";
import {routerMiddleware} from "react-router-redux";
import configureMockStore from "redux-mock-store";
// Put global test setup here (i.e. mocks)
import Enzyme, {mount, render, shallow} from "enzyme";
import fetchMock from "fetch-mock";
import MockDate from "mockdate";
import Adapter from "enzyme-adapter-react-16";

MockDate.set("2018-01-23T04:56Z");

global.fetch = fetchMock.sandbox();

// React 15 Enzyme adapter
Enzyme.configure({adapter: new Adapter()});

const shallowWithStore = (component, store) => {
  const context = {
    store,
  };
  return shallow(component, {context});
};

const mountWithStore = (component, store) => {
  const context = {
    store,
  };
  return mount(component, {context});
};

const testReduxState = {
  esk: {
    availabilityDataByTypeAndID: {1: {}},
  },
  goracle: {
    servicesByID: {
      1: {
        isFetching: false,
        service: {
          id: 1,
        },
      },
    },
  },
  service_view: {
    has_errored: false,
  },
};

const makeMockStore = function (storeState) {
  const middlewares = [thunk, routerMiddleware];
  const mockStore = configureMockStore(middlewares);

  if (storeState) {
    return mockStore(storeState);
  } else {
    return mockStore(testReduxState);
  }
};

const flushAllPromises = () => new Promise(resolve => setImmediate(resolve));

// Make Enzyme functions available in all test files without importing
global.shallow = shallow;
global.render = render;
global.mount = mount;
global.shallowWithStore = shallowWithStore;
global.mountWithStore = mountWithStore;
global.makeMockStore = makeMockStore;
global.testReduxState = testReduxState;
global.flushAllPromises = flushAllPromises;

// These helpers help with setting up default test data
