// These helpers help with setting up default test data
import thunk from "redux-thunk";
import {routerMiddleware} from "react-router-redux";
import configureMockStore from "redux-mock-store";

export testStore = {
  goracle: {
    servicesByID: {1: {}},
  },
  service_view: {
    has_errored: false,
  },
}

const middlewares = [thunk, routerMiddleware];
const mockStore = configureMockStore(middlewares);
export makeMockStore = function (storeData) {
  if (storeData) {
    return mockStore(storeData)
  } else {
    return mockStore(testStore)
  }
}
