# ENI VPC Flow Log Report Generator

This repository contains the code needed to create reports from ENI VPC Flow logs.

Unfortunately, it's loaded with assumptions about VPN usage, so it's not terribly portable as-is.
**That means this repo contains the VPN Server ENI Flow Log Reports.**

-   You may view them here: [https://git.xarth.tv/pages/awsi/eniflowner](https://git.xarth.tv/pages/awsi/eniflowner)

## Logic

There are 8 VPN servers, so 8 ENIs write flow data to cloudwatch logs. This application
runs in Jenkins every day and downloads the previous 24 hours of data from those 8 log
streams. It combines and aggregates all the flows by destination `ip:port`. The AWS
account (or bare metal) for each IP is looked up from an Isengard snapshot.

The app loads the previous day's report before writing a new one. That
means every day is an aggregation of the current day and all time previous.
Update: July 2021, it now writes a daily json file, so we can do aggregations
based on any time range. As more files are created, we'll expand on this.

Service names for known ports are applied. Some ports are filtered. Specifically things
that are not likely VPN user traffic; like puppet, nagios, statsd, etc.

Any service with port 443 is "polled" for its SSL certificate name. If a name is present,
it is applied to the report data. Once an SSL certificate is known for an IP, it is saved
in a yaml file so the "poll" only happens once (theoretically).

### Jenkins Creates

1.  New [json report](docs/json) for the current day, combined with the previous day(s).
1.  Updated [yaml file](docs/ipmap.yaml) with any newly-found https SSL cert names.
1.  New [HTML report](docs/html) for the current day, combined with the previous day(s).
1.  An entry in the [index.html](docs/index.html) file for the current day.
1.  A commit back into this repo in the `master` branch with the above changes.

## The Beginning

This is the output from the initial run that started the reports. 3 days of data to start!

```
Loaded 0 old flows. Grabbing 8 log streams events from past 73h0m0s (now: 2021-05-05 01:45:52 -0700 PDT)
Elapsed 3m29s grabbing 461956 events (139 batches) from (us-east-1) 'vpn-eni-flow-logs:eni-0b9bb8e050f30b4f8-accept' ip 10.160.2.75
Elapsed 29s grabbing 331856 events (47 batches) from (us-east-1) 'vpn-eni-flow-logs:eni-0aba6df4642d62519-accept' ip 10.160.0.254
Elapsed 56s grabbing 844439 events (115 batches) from (us-west-2) 'vpn-eni-flow-logs:eni-0fc9b2205c0759559-accept' ip 10.197.192.68
Elapsed 51s grabbing 795254 events (108 batches) from (us-west-2) 'vpn-eni-flow-logs:eni-042f4a6f74f2a5426-accept' ip 10.197.202.23
Elapsed 46s grabbing 453264 events (62 batches) from (eu-west-1) 'vpn-eni-flow-logs:eni-03acafaa4db94333d-accept' ip 10.176.211.87
Elapsed 1m2s grabbing 679667 events (92 batches) from (eu-west-1) 'vpn-eni-flow-logs:eni-0055d13cdbab78efe-accept' ip 10.176.211.61
Elapsed 25s grabbing 298742 events (41 batches) from (ap-southeast-1) 'vpn-eni-flow-logs:eni-0c94deba18d2474a9-accept' ip 10.166.23.151
Elapsed 29s grabbing 346749 events (47 batches) from (ap-southeast-1) 'vpn-eni-flow-logs:eni-0ee1f64ceaa6fbf1c-accept' ip 10.166.23.62
Found 4211927 total events over past 73h0m0s in 8m26s from 8 streams. Known IPs: 683
Processing elapsed 19m43s. Skipped 1504715 unusable or external events and filtered 392274.
The remaining events 2314938 aggregated to 3677 destinations.
```
