This application parses the log openvpnas log stream for user stats.

Gather connection errors:
```shell
export REGIONS="us-west-2 ap-southeast-1 eu-west-1 us-east-1"
export DAYS=60
mkdir data

for region in $REGIONS; do
  echo "$(date) Collecting openvpnas error logs from ${region} ... this will take up to ${DAYS} minutes."
  aws --profile=twitch-central-aws --region=${region} logs filter-log-events \
    --log-group-name=/ec2cwlog/openvpnas/production \
    --log-stream-name-prefix=/openvpn/var/log/jtv/openvpnas.log \
    --filter-pattern='"\"active\": 0" error' \
    --start-time=$(date -v -${DAYS}d +%s000) > errors_${region}.json
  cat errors_${region}.json | jq -r '.events[] | .message' | grep -o '{.*}' | sed "s/\\\'/'/g" > data/errors_${region}.txt
done
```

Gather disconnections:
```shell
export REGIONS="us-west-2 ap-southeast-1 eu-west-1 us-east-1"
export DAYS=60
mkdir data

for region in $REGIONS; do
  echo "$(date) Collecting openvpnas connection logs from ${region} ... this will take up to ${DAYS} minutes."
  aws --profile=twitch-central-aws --region="${region}" logs filter-log-events \
    --log-group-name=/ec2cwlog/openvpnas/production \
    --log-stream-name-prefix=/openvpn/var/log/jtv/openvpnas.log \
    --filter-pattern='"\"active\": 0" duration' \
    --start-time=$(date -v -${DAYS}d +%s000) > connections_${region}.json
  cat connections_${region}.json | jq -r '.events[] | .message' | grep -o '{.*}' | sed "s/\\\'/'/g" > data/connections_${region}.txt
done
```

Once you gather these txt files, you can feed them into the go app to create reports.
```shell
FIlES=$(ls data/connections*.txt | xargs | tr ' ' ',')
go run . -file $FILES  -report consbyday > connections_report.txt
```

```shell
FIlES=$(ls data/errors*.txt | xargs | tr ' ' ',')
go run . -file $FILES  -report errors > errors_report.txt
```
